<div class="header">
	<?=
		$this->Format->actions(array(
			array('add', __('Add new'), array(C => 'groups', A => 'add')),
			$this->Format->filter()
		))
	?>
<?= $this->Format->filter(array('_keyword')) ?>
</div>

<div class="groups index">
	<?php if(!empty($groups)) { ?>
		<?= $this->element('multiselect') ?>
		<table cellpadding="0" cellspacing="0">
			<tr>
				<th class="box"><input type="checkbox" /></th>
				<th class="title"><?= $this->Paginator->sort('name') ?></th>
				<th class="time"><?= $this->Paginator->sort('created') ?></th>
				<th class="actions"><?= __('Actions') ?></th>
			</tr>

			<?php foreach($groups as $i => $group) { ?>
				<tr class="<?= $i % 2 ? 'even' : 'odd' ?> row-<?= $i ?>">
					<td class="box"><?= $this->Form->checkbox('box-' . $group['Group']['id']) ?></td>
					<td class="title"><?= $this->Html->link($group['Group']['name'], array(C => 'groups', A => 'edit', $group['Group']['id'])) ?></td>
					<td class="time"><?= $group['Group']['created'] ?></td>
					<td class="actions">
						<?= $this->Html->link('', array(C => 'groups', A => 'view', $group['Group']['id']), array('class' => 'fa fa-fw fa-view', 'title' => __('View details'))) ?>
						<?= $this->Html->link('', array(C => 'groups', A => 'edit', $group['Group']['id']), array('class' => 'fa fa-fw fa-edit', 'title' => __('Edit'))) ?>
						<?= $this->Html->link('', array(C => 'groups', A => 'delete', $group['Group']['id']), array('class' => 'fa fa-fw fa-delete', 'title' => __('Delete'), 'confirm' => __('Are you sure you want to delete') . "\\n" . $group['Group']['title'] . ' ?')) ?>
					</td>
				</tr>
			<?php } ?>
		</table>
		<?= $this->element('multiselect') ?>

		<?= $this->element('paginator') ?>

	<?php } else echo '<div class="empty well">' . __('No groups have been found') . '</div>' ?>
</div>
