<?php

# Uploads
foreach($model->hasOne as $association => $params) {
	if($model->displayImage != $association) {
		$hasOne[__(Inflector::humanize($association))] = $this->Format->image($record[$association], 80, null, $association);
	}
}

# Main data
foreach($schema as $field => $schema) if(!in_array($field, array_merge($model->invisible, $skip))) {
	if($field == 'password') {
		continue;
	}
	$langs = !empty($schema['polyglot'])
		? array_keys(Configure::read('Config.Languages'))
		: array('');
	$values = array();
	foreach($langs as $locale) {
		$value = isset($record[$modelClass][$field . '__'][$locale])
			? $record[$modelClass][$field . '__'][$locale]
			: $record[$modelClass][$field];

		# url
		if($field == 'url') {
			$value = $this->Html->link($value, $value, array('target' => '_blank'));


			# _id
		} elseif(($id = substr($field, -3) == '_id') || (($var = Inflector::variable(Inflector::pluralize($field))) && isset($$var))) {

			if($id) {
				$var = Inflector::variable(Inflector::pluralize(substr($field, 0, -3)));
			}
			$var = $$var;
			$value = isset($var[$value]) ? $var[$value] : null;

			# _set
		} elseif(substr($field, -4) == '_set') {
			$association = Inflector::camelize(substr($field, 0, -4));

		} elseif($field == $model->displayField) {
			$value = '<div class="view-title">' . $value . '</div>';

		} else {
			switch($model->_schema[$field]['type']) {
				case 'boolean':
					$value = $this->Format->bool($record[$modelClass][$field]);
					break;
				case 'date':
					$value = $this->Format->time($value);
					break;
				case 'datetime':
					$value = $this->Format->time($value, true);
					break;
			}
		}

		if(is_array($value)) {
			$value = implode(', ', $value);
		}

		$values[$locale] = trim((string)$value);
	}
	$list[$field] = $values;
}

# Echo
echo '<div class="view-list view-overview">';
echo '<dl class="list">';
foreach($list as $field => $description) if(empty($fieldOptions[$field]['hide'])) {
	$after = !empty($fieldOptions[$field]['after']) ? $fieldOptions[$field]['after'] : '';
	$before = !empty($fieldOptions[$field]['before']) ? $fieldOptions[$field]['before'] : '';
	if(!empty($fieldOptions[$field]['wrap'])) {
		$before .= $fieldOptions[$field]['wrap'];
		$after .= preg_replace('/<([a-z]+).*/', '</$1>', $before) . '<div class="clear"></div>';
	}
	if(!empty($fieldOptions[$field]['encode'])) {
		$description = preg_replace("/\n+/", "\n", htmlentities($description));
	}

	$fieldname = __(Inflector::humanize($field));

	foreach($description as $locale => $value) {
		if(!empty($fieldOptions[$field]['pre']) || (isset($formOptions[$field]['rte']) && empty($formOptions[$field]['rte']))) {
			$value = $this->Html->tag('pre', htmlentities($value));
		}

		?>
		<dt class="list<?= !empty($locale) ? ' lang lang-' . $locale : '' ?>"<?= !empty($locale) && $locale != Configure::read('Config.language') ? ' style="display:none"' : '' ?> id="<?= $modelClass . Inflector::camelize($field) ?>"><?= $fieldname ?></dt>
		<dd class="list<?= !empty($locale) ? ' lang lang-' . $locale : '' ?> clearfix"<?= !empty($locale) && $locale != Configure::read('Config.language') ? ' style="display:none"' : '' ?> id="<?= $modelClass . Inflector::camelize($field) ?>"><?= $before . ($value !== '' ? $value : '&nbsp;') . $after ?></dd>
	<?php
	}
}
echo '</dl>';
echo '<div class="clear"></div>';
echo '</div>';
?>