<?php
	if(!isset($template)) $template = false;
	if(!isset($ruleIndex)) $ruleIndex = '!*!';
	if(!isset($validationRule)) $validationRule = null;
?>

<li class="<?= $template ? 'template' : '' ?>  <?= (!empty($validationRule) ? 'skip-initial' : '') ?> clearfix" data-field-index="<?= $index ?>" data-rule-index="<?= $ruleIndex ?>">

	<?php

		# Select a validation type
		echo $this->Form->input(
			'Module.Fields.' . $index . '.ModuleFieldRules.' . $ruleIndex . '.rule_id',
			array(
				'type' => 'select',
				'label' => false,
				'title' => __('Validation type'),
				'options' => $validationRules,
				'data-name' => 'data[Module][Fields][' . $index . '][ModuleFieldRules][!*!][rule_id]',
				'div' => array(
					'class' => 'input input-select field-validation-type clearfix'))
		);

		# Validation message
		echo $this->Form->input(
			'Module.Fields.' . $index . '.ModuleFieldRules.' . $ruleIndex . '.validation_message',
			array(
				'type' => 'text',
				'label' => false,
				'placeholder' => __('Validation message'),
				'title' => __('Validation message'),
				'div' => 'input input-select field-validation-message',
				'data-name' => 'data[Module][Fields][' . $index . '][ModuleFieldRules][!*!][validation_message]')
		);

		# Remove validation
		echo $this->Html->link(
			'<i class="fa fa-fw fa-trash">&nbsp;</i>',
			'javascript:void(0)',
			array(
				'escape' => false,
				'title' => __('Remove validation'),
				'class' => 'pull-right field-validation-remove')
		);

	?>

	<div class="field-validation-params">
		<?php if(!empty($validationRule['additional_data'])) { ?>
			<?php foreach($validationRule['additional_data'] as $additionalField => $additionalValue) { ?>
				<?= $this->Form->input('Module.Fields.' . $index . '.ModuleFieldRules.' . $ruleIndex . '.' . $additionalField, array('data-name' => 'data[Module][Fields][' . $index . '][ModuleFieldRules][!*!][' . $additionalField . ']', 'type' => 'text', 'div' => array('class' => 'input clearfix text'), 'label' => Inflector::humanize($additionalField))) ?>
			<?php } ?>
		<?php } ?>
	</div>

</li>
