<?php
	$caret = '<b class="caret"></b>';
	$attributes = array('class' => 'dropdown-toggle', 'data-toggle' => 'dropdown');
?>

<?php if(Configure::read('Backend.dashboard')) { ?>
	<li class="dashboard<?= $this->params['controller'] == 'dashboard' ? ' selected' : null ?>">
		<?= $this->Html->link('<i class="fa fa-fw fa-home"></i>', array(C => 'dashboard', A => 'index'), array('class' => 'dashboard')) ?>
	</li>
<?php } ?>

<?php if(Configure::read('Website.enabled')) { ?>
	<?php if(!empty($isSuperadmin)) { ?>
		<li class="dropdown">
			<?= $this->Html->link(__('Content') . $caret, array(C => 'pages', A => 'index'), $attributes) ?>
			<ul class="dropdown-menu">
				<li><?= $this->Html->link('<i class="fa fa-fw fa-sitemap"></i>' . __('Pages'), array(C => 'pages', A => 'index')) ?></li>
				<li class="divider"></li>
				<li><?= $this->Html->link('<i class="fa fa-fw fa-puzzle-piece"></i>' . __('Elements'), array(C => 'elements', A => 'index')) ?></li>
				<li><?= $this->Html->link('<i class="fa fa-fw fa-desktop"></i>' . __('Layouts'), array(C => 'layouts', A => 'index')) ?></li>
				<li><?= $this->Html->link('<i class="fa fa-fw fa-bars"></i>' . __('Templates'), array(C => 'templates', A => 'index')) ?></li>
				<li class="divider"></li>
				<li><?= $this->Html->link('<i class="fa fa-fw fa-text-height"></i>' . __('Stylesheets'), array(C => 'stylesheets', A => 'index')) ?></li>
				<li><?= $this->Html->link('<i class="fa fa-fw fa-cog"></i>' . __('Javascripts'), array(C => 'javascripts', A => 'index')) ?></li>
			</ul>
		</li>
	<?php } else { ?>
		<li><?= $this->Html->link('<i class="fa fa-fw fa-sitemap"></i>' . __('Pages'), array(C => 'pages', A => 'index')) ?></li>
	<?php } ?>
<?php } ?>

<?php

	if(!empty($modulesMenu)) foreach($modulesMenu as $category) {

		# Modules
		$modules = array();
		foreach($category['modules'] as $module) {
			$badge = $module['badge'] !== null ? "<em>{$module['badge']}</em>" : null;

			$link = $this->Html->link($module['icon'] . ' ' . $module['name'] . $badge, $module['link']);
			$modules[] = $this->Html->tag('li', $link, array('class' => isset($module['link'][C]) && Inflector::underscore($module['link'][C]) == Inflector::underscore($this->params->controller) ? 'selected' : null));
		}

		# Category start
		if(!empty($category['name']) && !empty($category['modules'])) {
			$badge = !empty($category['badge']) ? "<em>{$category['badge']}</em>" : null;

			echo '<li class="dropdown">';
			echo $this->Html->link($category['name'] . $badge . $caret, '#', $attributes);
			echo '<ul class="dropdown-menu">';
		}

		echo implode("\n", $modules);

		# Category end
		if(!empty($category['name']) && !empty($category['modules'])) {
			echo '</ul></li>';
		}

	}

?>

<?php if (Configure::read('Feature.mailchimp_api_key')) { ?>
	<li>
		<?= $this->Html->link('<i class="fa fa-fw fa-envelope"></i>' . __('Newsletter'), [ P => 'newsletter', C => 'campaigns', A => 'index' ]) ?>
	</li>
<?php } ?>

<?php if (Configure::read('Feature.SEO')) { ?>
	<li class="dropdown">
		<?= $this->Html->link(__('Seo') . $caret, array(C => 'pages', A => 'index'), $attributes) ?>
		<ul class="dropdown-menu">
			<li><?= $this->Html->link('<i class="fa fa-fw fa-cog"></i>' . __('Configuration'), array(C => 'seo_configs', A => 'index')) ?></li>
			<li class="divider"></li>
			<li><?= $this->Html->link('<i class="fa fa-fw fa-link"></i>' . __('Redirections'), array(C => 'seo_redirections', A => 'index')) ?></li>
		</ul>
	</li>
<?php } ?>

<?php if(Configure::read('Feature.newsletter')) { ?>
	<li class="dropdown">
		<?= $this->Html->link(__('Newsletters') . $caret, 'javascript:void(0)', $attributes) ?>
		<ul class="dropdown-menu">
			<li><?= $this->Html->link('<i class="fa fa-fw fa-plus"></i>' . __('Send new'), array(P => 'newsletter', C => 'newsletters', A => 'add')) ?></li>
			<li><?= $this->Html->link('<i class="fa fa-fw fa-send"></i>' . __('Sent newsletters'), array(P => 'newsletter', C => 'newsletters', A => 'index')) ?></li>
			<li><?= $this->Html->link('<i class="fa fa-fw fa-list"></i>' . __('Lists'), array(P => 'newsletter', C => 'lists', A => 'index')) ?></li>
			<li><?= $this->Html->link('<i class="fa fa-fw fa-file"></i>' . __('Templates'), array(P => 'newsletter', C => 'templates', A => 'index')) ?></li>
			<li class="divider"></li>
			<li><?= $this->Html->link('<i class="fa fa-fw fa-gears"></i>' . __('Emails'), array(P => 'newsletter', C => 'from_emails', A => 'index')) ?></li>
		</ul>
	</li>
<?php } ?>
