<footer>

	<?php if(!empty($isSuperadmin)) {

		# Additional style
		echo '<style>footer a { padding: 6px 12px; } footer span { padding: 6px 0; }</style>';

		# Website name
		$info[] = $this->Html->link(Configure::read('Website.title'), Configure::read('Website.enabled') ? FRONT_BASE_URL : BACK_BASE_URL, Configure::read('Website.enabled') ? array('target' => '_blank', 'title' => Configure::read('Website.enabled') ? __('Website is enabled') : __('Front website is disabled')) : array());

		# Host name and IP
		$info[] = $this->Html->link(gethostname() . ' ' . @$_SERVER['SERVER_ADDR'], 'http://www.geoiptool.com/en/?ip=' . @$_SERVER['SERVER_ADDR'], array('target' => '_blank', 'title' => __('Show on map')));

		# Used database
		$info[] = $this->Html->link(ConnectionManager::getDataSource('default')->config['database'] . ' @ ' . ConnectionManager::getDataSource('default')->config['host'], array(P => null, C => 'tools', A => 'phpMyAdmin'), array('target' => '_blank', 'title' => __('Open phpMyAdmin')));

		# Debug status
		$info[] = $this->Html->link('debug: ' . Configure::read('debug'), array(P => null, C => 'configs', A => 'index', '#' => 'Development'), array('title' => __('Click to change')));

		# Server time
		$info[] = $this->Html->link(date_default_timezone_get() . ': ' . date('Y-m-d H:i:s'), array(P => null, C => 'tools', A => 'phpinfo'), array('title' => __('Show PHP info')));

		echo implode(' <span>|</span> ', $info);

	} else if($this->Format->override('footer')) {
		echo $this->Format->override('footer');

	} else { ?>
		<a href="https://intellex.rs/<?= !empty($locale) && in_array($locale, array('sr', 'en')) ? $locale : 'en' ?>" class="intellex" title="<?= __('Intellex, web and mobile development') ?>" target="_blank">
			<?php if(empty($administrator)) { ?>
				<img src="/img/intellex/intellex_logo.png" alt="Intellex mobile and web development" class="pull-left intellex" />
				<div class="pull-left intellex">
					<?= __('Consultation, design and development') . '<br />' . __('of mobile and web applications') ?>
				</div>
			<?php } else { ?>
				<img src="/img/intellex/intellex_logo_small.png" alt="Intellex mobile and web development" class="pull-left intellex" />
			<?php } ?>
		</a>
	<?php } ?>

	<?php

		# Default text
		$versionOfCMS = __('CMS version') . ': ' . CMS_VERSION;

		# Element attributes
		$attributes = array(
			'title' => CMS_VERSION_DATE . (!empty($isSuperadmin) ? '   |   ' . CMS_VERSION_CODE : null),
			'class' => 'version');

		# Print the version
		echo $this->Html->link($versionOfCMS, array(P => null, C => 'tools', A => 'version'), $attributes);

	?>

	<?php if(Configure::read('debug') >= 2 && !Configure::read('isAJax')) { ?>
		<a class="debug" name="debug" href="#debug" onclick="$('section.debug').toggle();"><?= __('Show debug info') ?> (<?= sprintf('%0.2f', round(microtime(true) - TIME_START, 2)) ?> sec)</a>
		<script type="text/javascript">

			// Smooth scroll for debug
			$('footer a.debug').click(function() {
				var name = $(this).attr('href').replace('#', '');
				var target = $('a[name=' + name + ']');

				if(target.length > 0) {
					var contentPosTop = $(target).offset().top - 83;

					$('html, body').stop().animate({
						scrollTop: contentPosTop
					}, 350);
				}

				return false;
			});
		</script>
	<?php } ?>

</footer>
