<?php $treeType = 'module' ?>
<?php ob_start() ?>
<ul class="side-sortable"<?= empty($level) ? ' id="sidetree"' : '' ?>>
	<?php
	if (empty($display_tree)) {
		if (!empty($category_tree)) {
			$display_tree = $category_tree;
			$treeType = 'category';
		} else {
			$display_tree = $tree;
		}
	}

	foreach ($display_tree as $node) {
		$children = !empty($node['children'])
			? $this->element('index/side_tree', [ 'display_tree' => $node['children'], 'level' => isset($level) ? $level + 1 : 1 ])
			: '';

		$node_controller = $controller;
		$node_name = '';
		$node_class = $modelClass;
		$node_key = 'parent_id';

		if (isset($treeview) && $treeview) {
			$node_name = $node[$modelClass][$displayField];
		} else {
			$node_key = 'category_id';
			$node_class = 'Category';
			$node_controller = "{$modelClass}/categories";
			$node_name = $node['Category']['title'];
		}

		$short_node_name = CakeText::truncate($node_name, 22 - (isset($level) ? $level - 1 : 0) * 3);

		$actions = '';
		$actions .= $this->Html->link(null, [ C => $node_controller, A => 'add', $node_key => $node[$node_class]['id'] ], [ 'class' => 'fa fa-plus icon' ]);
		$actions .= $this->Html->link(null, [ C => $node_controller, A => 'filter_tree', $modelClass, $node_key, $node[$node_class]['id'] ], [ 'class' => 'fa fa-search icon' ]);
		// $actions .= $this->Html->link(null, array(C => $node_controller, A => 'edit', $node[$node_class]['id']), array('class' => 'fa fa-pencil icon'));
		$mainLink = $this->Html->link($short_node_name, [ C => $node_controller, A => 'edit', $node[$node_class]['id'] ], [ 'class' => 'tree-item-link', 'title' => $node_name ]);

		echo $this->Html->tag('li', " <span class=\"controls\">" . $mainLink . $actions . '</span>' . $children, [ 'rel' => $node[$node_class]['id'] ]);
	}
	?>
</ul>
<?php $list = ob_get_clean();
if (!empty($level)) {
	echo $list;
	return;
} ?>

<?php
$sidebarTitle = __('Tree view');
if (isset($treeType) && $treeType == 'category') {
	$sidebarTitle = __('Categories');
}
?>
<h4 class="side-bar-header">
	<?= $sidebarTitle ?>
</h4>

<div class="side-bar-content">
	<div id="SideTree" class="side-tree-wrapper" tabindex="-1" role="dialog" aria-labelledby="" aria-hidden="">
		<div class="tree-view-body">
			<?= $list ?>
			<script type="text/javascript">
				var delta = 0;
				$(function () {

					$('#SideTree').on('hide', function () {
						location.reload();
					});

					$('.side-sortable').sortable({
						placeholder: 'placeholder',
						forcePlaceholderSize: true,
						start: function (event, ui) {
							delta = $(ui.item).nextAll().length;
						},
						stop: function (event, ui) {
							delta = delta - $(ui.item).nextAll().length - 1;
							if (delta != 0) {
								$.get('<?= $this->Html->url([ C => $controller, A => 'sort_tree' ]) ?>/' + $(ui.item).attr('rel') + '/' + delta + '<?= "/" . (!empty($category_tree) ? 'Category' : $modelClass) ?>' + '<?= "/" . (!empty($category_tree) ? $modelClass : '') ?>');
							}
						}
					});
					$("#sidetree").treeview();
				});
			</script>
		</div>
	</div>
</div>
