<div class="multiselect">

	<div class="btn-toolbar">
		<div class="btn-group select">
			<?= $this->Html->link(__('select all'), 'javascript: void(0)', 'select-all btn btn-sm') ?>
			<?= $this->Html->link(__('none'), 'javascript: void(0)', 'select-none btn btn-sm') ?>
			<?= $this->Html->link(__('invert'), 'javascript: void(0)', 'select-invert btn btn-sm') ?>
		</div>

		<div class="btn-group mass-action" style="margin-left: 12px; display: none">
			<?php

				# Send emails
				if($model->schema('email')) {
					echo $this->Html->link('<i class="fa fa-envelope"></i>' . __('Send email'), '#ChooseTemplateModal', array( 'class' => 'send-emails action btn btn-sm', 'data-toggle' => 'modal'));
				}

				# Mass edit
				if($model->isEditable()) {
					echo $this->Html->link('<i class="fa fa-pencil"></i>' . __('Edit'), array(C => $this->request->params['controller'], A => 'edit'), 'mass-edit action btn btn-sm');
				}

				# Mass delete
				if($model->isDeletable()) {
					echo $this->Html->link('<i class="fa fa-trash-o"></i>' . __('Delete'), array(C => $this->request->params['controller'], A => 'delete'), 'mass-delete action btn btn-sm btn-danger');
				}
			?>
		</div>
	</div>

	<?php if(!Configure::read('hasMassActions')) { Configure::write('hasMassActions', true) ?>
		<script type="text/javascript">
			var sh = -1;
			var shAction = null;

			$(document).ready(function() {

				// Select all
				$('.select-all').click(function() {
					$('.index table tr:visible').toggleSelect(true);
				});

				// Select none
				$('.select-none').click(function() {
					$('.index table tr:visible').toggleSelect(false);
				});

				// Select invert
				$('.select-invert').click(function() {
					$('.index table tr:visible').toggleSelect();
				});

				// Checkbox click
				$('.index table tr :checkbox').change(function() {
					toggleMassActions();
				});

				// Mass edit
				$('.mass-edit').click(function() {
					var list = '';
					$('td.box :checked').each(function(i, box) { list += '/' + $(box).val(); });

					if(list != '') {
						location.href = $(this).attr('href') + list;
					}

					return false;
				});

				// Mass delete
				$('.mass-delete').click(function() {
					var list = '';
					$('td.box :checked').each(function(i, box) { list += '/' + $(box).val(); });

					if(list != '' && confirm('<?= __('Are you sure you want to delete all selected records?') ?>')) {
						location.href = $(this).attr('href') + list;
					}

					return false;
				});

				// Hover effect for table rows
				$('table tr').hoverClass();

				// Allow multiple selection with shift
				$('td.box :checkbox').click(function(event) {
					var tr = $(this).closest('tr');
					var current = tr.prevAll().length;
					if(!event.shiftKey) {
						sh = current;
						shAction = $(this).is(':checked');
						tr.toggleSelect(shAction);

					} else if(sh != current) {
						var from = Math.min(sh, current);
						var to = Math.abs(current - sh);
						$('.index table tr:gt(' + from + '):lt(' + to + ')').toggleSelect(shAction);
					}
				});


				// Make sure mass actions are displayed propery
				toggleMassActions();
			});

			function toggleMassActions() {
				var anySelected = $('.index table tr :checkbox:checked').length > 0;
				$('.mass-action').toggle(anySelected);
			}

			$.fn.toggleSelect = function(value) {
				$(this).find(':checkbox').each(function() {
					this.checked = typeof(value) != 'undefined' ? value : !this.checked;
				});

				// Hide or show mass actions
				toggleMassActions();
			}

		</script>
	<?php } ?>
</div>
