<?php

	# TODO: Plugin syntax with . breaks customization save
	$modelWithPlugin = (!empty($modelPlugin) ? ucfirst($modelPlugin) . '.' : '') . $modelClass;
?>
<div id="CustomizeTableModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
	<div class="modal-dialog">
		<?= $this->Form->create('Administrator', array('url' => '/administrators/customize/' . $modelWithPlugin, 'class' => 'customization ajax modal-content')) ?>

			<div class="modal-header">
				<button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
				<h4><?= __('Customization of table view') ?></h4>
			</div>

			<div class="modal-body">
				<div class="administrators form" style="margin: 0">
					<?php
						$ordered = $unordered = array();
						foreach($fields as $field) {
							if(is_array($field)) continue;
							$label = preg_replace('/_id$/', '', $field);

							Timer::startLoop('Test'); {
								$link = $this->Html->link(__(Inflector::humanize($label)), 'javascript: void(0)', $this->Form->value("Administrator.customization.{$modelClass}.{$field}.show") ? 'selected' : null);
								$hidden = $this->Form->hidden("Administrator.customization.{$modelClass}.{$field}.show");
							} Timer::endLoop('Test');

							$li = $this->Html->tag('li', $link . $hidden);
							if(isset($ordering[$field]['ordering'])) {
								$ordered[$ordering[$field]['ordering']] = $li;
							} else {
								$unordered[] = $li;
							}
						}
						ksort($ordered);

						echo $this->Html->tag('ul', implode(array_merge($ordered, $unordered)), 'sortable');
					?>
				</div>
			</div>

			<div class="modal-footer">
				<input type="submit" class="btn btn-primary" value="<?= __('Save and close') ?>" data-click-feedback="<?= __('Please wait...') ?>" />
			</div>

		</form>

		<script type="text/javascript">
			$(document).ready(function() {

				// Sort customize view
				$('form.customization ul.sortable').sortable({
					axis: 'y',
					forcePlaceholderSize: true,
					beforeStop: function(event, ui) {  }
				});

				// Select fields
				$('form.customization ul.sortable a').click(function() {
					var input = $(this).next();
					if(input.val() == 1) {
						input.val(0);
						$(this).removeClass('selected');
					} else {
						input.val(1);
						$(this).addClass('selected');
					}
				});
			});
		</script>
	</div>
</div>
