<?php
/**
 * @var bool     $multiple    True if rendering multiple upload.
 * @var string   $comment     Additional comment for upload.
 * @var AppModel $model       The parent model for this form.
 * @var string   $association The upload association which we are showing.
 * @var array    $uploads     The already uploaded files.
 * @var boolean  $images      True of uploads are just images, false otherwise.
 * @var string   $placeholder The path to the image, which acts as a placeholder to help in keeping
 *      the universal size between files and upload placeholders.
 */

# Get the initial option
$initial = 'list';
if($images) {
	$initial = $multiple ? 'gallery' : 'grid';
}
?>
<div class="input">
	<div class="row">
		<div class="adjusted col-md-3 col-lg-2">
			<label><?= $label ?></label>
		</div>

		<div class="adjusted col-md-9 col-lg-10">
			<div class="vector-upload-wrapper vector-upload-<?= $initial ?>-view <?= !empty($div['class']) ? $div['class'] : 'input' ?>"<?= isset($div['style']) ? ' style="' . $div['style'] . '"' : '' ?>>

				<div class="upload-comment"><?= $comment ?></div>

				<?php if ($multiple && $images) { ?>
					<div class="vector-upload-heading">
						<div class="vector-upload-switcher">
							<ul>
								<li>
									<a data-list-action="list" href="javascript:void(0)">
										<i class="fa fa-list"></i> <?= __('List view') ?>
									</a>
								</li>
								<li>
									<a data-list-action="grid" href="javascript:void(0)">
										<i class="fa fa-th"></i> <?= __('Grid view') ?>
									</a>
								</li>
								<li>
									<a data-list-action="gallery" href="javascript:void(0)" class="active">
										<i class="fa fa-th-large"></i> <?= __('Gallery view') ?>
									</a>
								</li>
							</ul>
						</div>
					</div>
				<?php } ?>

				<div class="vector-upload-body">
					<div class="vector-upload-group upload-sortable" id="UploadListFor<?= $association ?>">
						<div class="cssloader"><?= __('Loading...') ?></div>
					</div>
				</div>

			</div>
		</div>
	</div>

	<script>
		postExecute(function () {
			new UploadHandler('<?= $model->name ?>', '<?= $association ?>', <?= json_encode(array_values($uploads)) ?>, <?= $multiple ? 'true' : 'false' ?>, <?= json_encode($placeholder) ?>);
		});
	</script>
</div>
