<?php
	ob_start();

	# Make sure we have the model
	if(!isset($model)) {
		$model = ClassRegistry::init($modelClass);
	}

	# Default model plugin
	if(empty($modelPlugin)) {
		$modelPlugin = null;
	}

	if(!isset($showPolyglotTabs)) {
		$showPolyglotTabs = false;
	}
?>
<div class="header<?= !empty($showSidebar) ? ' with-sidebar' : null ?>">

	<?php

		# Show polyglot tabs
		if($showPolyglotTabs) {
			echo $this->Form->polyglotTabs();
		}

		# Edit or new record
		$edit = !empty($this->request->data[$modelClass][$model->primaryKey]);

		# Disabled fields
		if(empty($disabled)) $disabled = array();

		# Additional options
		$more = array(); {

			# Additional save buttons in the header
			if(Configure::read('Feature.save_buttons')) {
				$more[] = array(

					# Separator
					$edit
						? '<li class="separator"></li>'
						: null,

					# Apply button
					$edit
						? array("play", __('Apply'), $this->Format->pageLink(null), array('class' => 'btn btn-default', 'name' => 'apply-btn', 'onclick' => "$(this).closest('form').find('[name=\'apply-btn\'][type=\'submit\']').click()"))
						: null,

					# Duplicate of save button
					$edit
						? array("check", __('Save and close'), $this->Format->pageLink(null), array('class' => 'btn btn-primary', 'onclick' => "$(this).closest('form').find('[type=\'submit\'][name=\'save-btn\']').click()"))
						: null,

					# Duplicate of cancel button
					$model->isListable() && !in_array('list', $disabled) || !in_array('view', $disabled)
						? array(null, __('Cancel'), 'javascript: void(0)',	array('class' => 'btn btn-default', 'onclick' => 'dataHasChanged = false; location.href = \'' . $this->Html->url(array(C => $this->request->params['controller'], A => 'index')) . '\''))
						: null);
			}
		}

		# Additional actions
		$additional = array();
		if(!empty($_actions)) {
			$additional = array_merge($additional, $_actions);
		}

		# Join additional options
		foreach($more as $options) {
			$additional = array_merge($additional, $options);
		}

		# Print options
		echo $this->Format->actions($actions = array_merge(array(

			# Edit original
			!empty($copy) && !in_array('edit', $disabled)
				? array('pencil', __('Edit the original'), array(P => $modelPlugin, C => $controller, A => 'edit', $copy))
				: null,

			# Details
			$edit && !in_array('view', $disabled)
				? array('eye', __('Details'), array(P => $modelPlugin, C => $controller, A => 'view', $this->request->data[$modelClass][$model->primaryKey]))
				: null,

			# Delete
			$edit && $model->isDeletable($this->request->data[$modelClass][$model->primaryKey]) && !in_array('delete', $disabled)
				? array('trash-o', __('Delete'), array(P => $modelPlugin, C => $controller, A => 'delete', $this->request->data[$modelClass][$model->primaryKey]), array('class' => 'btn', 'confirm' => __('Are you sure you want to delete') . (!empty($this->request->data[$modelClass][$model->displayField]) ? ":\n" . $this->request->data[$modelClass][$model->displayField] : ' ' . __('this record')) . ' ?'))
				: null,

			# Create a copy
			$edit && $model->isCopyable($this->request->data[$modelClass][$model->primaryKey]) && !in_array('copy', $disabled)
				? array('copy', __('Create a copy'), array(P => $modelPlugin, C => $controller, A => 'copy', $this->request->data[$modelClass][$model->primaryKey]))
				: null,

			# Create new
			$edit && $model->isAddable() && !in_array('add', $disabled)
				? array('plus', __('Add new'), array(P => $modelPlugin, C => $controller, A => 'add'))
				: null,

			# List all records
			$model->isListable() && !in_array('list', $disabled)
				? array('list', __('List all'), array(P => $modelPlugin, C => $controller, A => 'index'))
				: null,

			# View page on front
			$modelClass == 'Page' && $edit && !in_array('show', $disabled)
				? array('eye', __('View Page'), $this->Format->pageLink($this->request->data[$modelClass][$model->primaryKey]), array('class' => 'btn', 'target' => '_blank'))
				: null)

			, $additional
			, $model->getFormActions($this->request->data))

		);
	?>
</div>

<?php

	# If there are no actions, do not show anything
	$header = ob_get_clean();
	foreach($actions as $action) if($action) {
		echo $header;
		break;
	}
?>
