<?php if (!class_exists('ConnectionManager') || Configure::read('debug') < 2 || Configure::read('isAjax')) return false ?>

<?php
	$items = Timer::getItems();
	$loops = Timer::getLoopItems();
?>

<style>
	div.timerReport em { display: block; background: #7B91A4; font: normal 11px Verdana; color: white; border: 1px solid #777; border-bottom: 1px solid #647B8E; padding: 3px 13px 4px; text-align: left; }
	div.timerReport ul { border: 1px solid #7B91A4; border-top: none; }
	div.timerReport ul li { font: normal 14px Courier; background: #fff; line-height: 28px; padding: 0 20px; }
	div.timerReport ul li:nth-child(2n) { background: #E9E9E9; }
	div.timerReport ul li i { color: #aaa; font: normal 14px Courier; }
	div.timerReport ul li strong { font: normal 14px Courier; line-height: 28px; }
</style>

<div class="row">

	<div class="col-md-6">
		<div class="timerReport sync">
			<em><?= __('Total execution time') ?>: <?= round((microtime(true) - TIME_START) * 1000) ?> ms</em>
			<ul>
				<?php if(!empty($items)) { ?>
					<?php foreach($items as $item) printTimerItem($item) ?>
				<?php } else { ?>
					<li><?= __('No items') ?></li>
				<?php } ?>
			</ul>
		</div>
	</div>

	<div class="col-md-6">
		<div class="timerReport async">
			<em><?= __('Loop timers') ?></em>
			<ul>
				<?php if(!empty($loops)) { ?>
					<?php foreach($loops as $item) { ?>
						<li>
							<div class="row">
								<div class="col-xs-9">
									<strong><?= $item->getName() ?> x<?= $item->getCount() ?></strong>
								</div>
								<div class="col-xs-3 text-right">
									<span><?= round($item->getTotalTime() * 1000) ?></span>
								</div>
							</div>
						</li>
					<?php } ?>
				<?php } else { ?>
					<li><?= __('No looped items') ?></li>
				<?php } ?>
			</ul>
		</div>
	</div>
</div>

<?php
	function printTimerItem($item, $level = 0) {
		$dashes = '<i>' . str_repeat('. . ', $level) . '</i>';
		?>
			<li>
				<div class="row">
					<div class="col-xs-9">
						<strong><?= $dashes ?><?= $item->getName() ?></strong>
					</div>
					<div class="col-xs-3 text-right">
						<span><?= round($item->getTime() * 1000) ?></span>
					</div>
				</div>
			</li>
		<?php

		$children = $item->getChildren();
		foreach($children as $child) {
			printTimerItem($child, $level + 1);
		}
	}
?>
