<div class="configuration form">
	<div class="tabbed clearfix">

		<ul class="nav nav-tabs">
			<?php foreach ($this->Form->data as $group => $items) { ?>
				<li><a href="#<?= $group ?>"><?= $group ?></a></li>
			<?php } ?>
		</ul>

		<?= $this->Form->create('Config') ?>
		<?php foreach ($this->Form->data as $group => $items) {
			$subgroup = null; ?>
			<div class="tab multiple" id="<?= $group ?>Tab" style="display: none">
				<?php
				foreach ($items as $i => $item) {

					# Subgroup
					$between = null;
					if (!empty($item['subgroup']) && empty($subgroup) || $subgroup != $item['subgroup']) {
						echo $i ? '<hr />' : '<br />';
						echo "<div class=\"row\"><div class=\"adjusted col-md-2\"></div><div class=\"adjusted col-md-10\"><h5 class=\"field-header\">{$item['subgroup']}</h5></div></div>";
						$subgroup = $item['subgroup'];
					}

					# Get the options
					$style = '';
					$label = $item['description'];
					$type = strtolower($item['type']);
					$options = [];
					$value = $item['value'];

					# Special options
					switch ($type) {
						case 'select':
							$options = unserialize($item['options']);
							break;

						case 'textarea':
							$style = 'font-family: Monospace, Courier New, Courier; height: 200px;';
							break;

						case 'string':
							$type = 'text';
							break;
					}

					# Start the form
					$adjust = 'labeled';
					echo $this->Form->input("Config.{$item['id']}", compact('value', 'type', 'options', 'label', 'style', 'adjust', 'between'));
				}
				?>
			</div>
		<?php } ?>

		<?= $this->Form->close('apply') ?>
	</div>
</div>

<script type="text/javascript">

	// Tabs
	$('.nav a').click(function (event) {
		$('.tab').hide();
		$($(this).attr('href') + 'Tab').show();
		$(this).closest('li').addClass('active').siblings().removeClass('active');

		location.href = $(this).attr('href');
		event.preventDefault();
		return false;
	});

	// Open proper tab
	if (location.hash == '') {
		$('.nav a:first').click();
	} else {
		$('.nav a[href=' + location.hash + ']').click();
	}

	// Clear form action
	$('#ConfigIndexForm').attr('action', '');

</script>
