<?php
require_once 'phpQuery.php';

class WebCrawler {

	protected $url = null;
	protected $base = null;

# ~ Constructor	 - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - #
	public function __construct($url) {

		# If partial
		if($this->base && !strpos($url, '://')) {
			$url = rtrim($this->base, '/ ') . '/' . ltrim($url, '/ ');
		}

		# If no protocol
		if(!strpos($url, '://')) {
			$url = 'http://' . $url;
		}

		$this->url = $url;
	}


# ~ Recursive trim - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - #
	public function trim($string) {
		if(is_array($string)) {
			foreach($string as $key => $value) {
				$string[$key] = $this->trim($value);
			}
			return $string;
		}

		return trim($string);
	}


# ~ -phpQuery wrapper  - - - - - - - - - - - - - - - - - - - - - - - - - - - - #
	public function pq($selector = '*', $context = null) {
		return pq($selector, $context);
	}


# ~ Read the url - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - #
	public function read($post = null, $header = array(), $cookie = null) {

		# Initialize curl
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $this->url);
		curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_USERAGENT, "Mozilla/4.0 (compatible; MSIE 5.01; Windows NT 5.0)");

		# Cookie
		if($cookie) {
			curl_setopt($ch, CURLOPT_COOKIEJAR, $cookie);
			curl_setopt($ch, CURLOPT_COOKIEFILE, $cookie);
		}

		# Debug
		if(false) {
			curl_setopt($ch, CURLOPT_VERBOSE, true);
			$verbose = fopen('php://temp', 'rw+');
			curl_setopt($ch, CURLOPT_STDERR, $verbose);
		}

		# Post
		if($post) {

			# Post from array
			if(is_array($post)) {
				$post = urldecode(http_build_query($post));
			}

			curl_setopt($ch, CURLOPT_POST, true);
			curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
		}

		# HTTP header
		if($header) {

			# Referer
			if(!empty($header['Referer'])) {
				curl_setopt($ch, CURLOPT_REFERER, $header['Referer']);
				unset($header['Referer']);
			}

			# Headers from array
			$head = array();
			foreach($header as $key => $value) {
				$head[] = "{$key}: {$value}";
			}

			curl_setopt($ch, CURLOPT_HEADER, true);
			curl_setopt($ch, CURLOPT_HTTPHEADER, $head);
		}

		$this->data = curl_exec($ch);
		if($this->data === false) {
			// $this->log('cURL: ' . (curl_error($ch) ? '#' . curl_errno($ch) . ' ' . curl_error($ch) : 'Unknown ERROR'), ERROR);
			curl_close($ch);
			exit(1);
		}
		$info = curl_getinfo($ch);
		curl_close($ch);

		# Get the log
		if(!empty($verbose)) {
			rewind($verbose);
			$verboseLog = stream_get_contents($verbose);
			echo "Verbose information:\n<pre>", htmlspecialchars($verboseLog), "</pre>\n";
			die;
		}

		# Manually follow redirects
		if(!empty($info['redirect_url'])) {
			return $this->read($info['redirect_url'], $post, $header);
		}

		try {
			phpQuery::newDocument($this->data);
		} catch(Exception $e) {}
		return $this->data;
	}

}
