<?php namespace JsonApi\Data;

class DataArray implements \JsonSerializable {

	public function __construct(array $data = []) {
		$this->data = $data;
	}

	public function add(DataItem $item) {
		$this->data[] = $this->validateItem($item);
	}

	public function validate($data) {

		# Must be an array
		if(!is_array($data)) {
			throw new \Exception('Data must be an array.');
		}

		# Validate each
		foreach($data as $item) {
			$this->validateItem($item);
		}
	}

	public function validateItem(DataItem $item) {
		if(!($item instanceof DataItem)) {
			throw new \Exception('Not an instance of `DataItem`.');
		}

		return $item;
	}

	public function jsonSerialize() {
		return $this->data;
	}

}
