<?php

class XmlAdapter {


# ~ Export data to XML file format - - - - - - - - - - - - - - - - - - - - - - #
	public function export($records, $columns, $filename = null) {

		# Get filename
		$filename = date('Y.m.d H:i') . '-' . $filename . '.xml';

		# Initialize xml document
		@date_default_timezone_set("GMT");
		$writer = new XMLWriter();
		$writer->openMemory();
		$writer->startDocument('1.0');
		$writer->setIndent(true);

		# Write records
		$writer->startElement('records');
		foreach($records as $record) {
			$writer->startElement('record');
			foreach($record as $key => $value) {
				$writer->writeElement($key, $value);
			}
			$writer->endElement();
		}
		$writer->endElement();

		# End document
		$writer->endDocument();

		# Output to browser
		header('Content-type: text/xml');
		header('Content-Disposition: attachment; filename="' . $filename .'"');
		echo $writer->outputMemory();

		exit;
	}

}
