<?php
namespace IntellexApps\PHP\UploadFile\Handler;

use IntellexApps\PHP\UploadFile\Network\JsonResponse;
use IntellexApps\PHP\UploadFile\Util\Configuration;

class ExceptionHandler {

    /**
     * Handle exception
     *
     * @param $e
     */
    public static function handle(\Exception $e)
    {
        $data = [
            'code' => $e->getCode(),
            'error' => $e->getMessage()
        ];

        if(Configuration::read('debug')) {
            $data = array_merge($data, [
                'debug' => [
                    'file' => $e->getFile(),
                    'line' => $e->getLine(),
                    'stack' => $e->getTraceAsString()
                ]
            ]);
        }

        // TODO: Use some class here
        $response = new JsonResponse($data);
        $response->setStatus($e->getCode());
        $response->output();
    }
}