<?php
namespace IntellexApps\PHP\UploadFile\Domain\Request\Permission;

use IntellexApps\PHP\UploadFile\Domain\Request\ApiRequest;
use IntellexApps\PHP\UploadFile\Network\Request;

/**
 * @SWG\Definition(definition="ChangePermissionRequest", type="object", required={"path","roleId","permission"})
 */
class ChangePermissionRequest extends ApiRequest
{

    /**
     * @var string
     * @SWG\Property()
     */
    var $path;

    /**
     * @var int
     * @SWG\Property()
     */
    var $roleId;

    /**
     * @var string
     * @SWG\Property()
     */
    var $permission;

    /**
     * Build from request
     *
     * @param Request $request
     */
    protected function build(Request $request)
    {
        $this->requireParams([
            'path', 'roleId', 'permission'
        ]);

        $this->path = $request->get('path');
        $this->roleId = $request->get('roleId');
        $this->permission = $request->get('permission');
    }

    /**
     * @return string
     */
    public function getPath()
    {
        return $this->path;
    }

    /**
     * @return int
     */
    public function getRoleId()
    {
        return $this->roleId;
    }

    /**
     * @return string
     */
    public function getPermission()
    {
        return $this->permission;
    }

}