<?php
namespace IntellexApps\PHP\UploadFile\Domain\Request\File;

use IntellexApps\PHP\UploadFile\Domain\Request\ApiRequest;
use IntellexApps\PHP\UploadFile\Network\Request;
use IntellexApps\PHP\UploadFile\Util\Inflector;

/**
 * @SWG\Definition(definition="ViewRequest", type="object", required={"path"})
 */
class ViewItemRequest extends ApiRequest
{

    /**
     * @var string
     * @SWG\Property()
     */
    var $path;

    /**
     * Build from request
     *
     * @param $request
     */
    protected function build(Request $request)
    {
        $this->requireParams([
            'path'
        ]);
        $this->path = Inflector::leadingSeparator($request->get('path'));
    }

    /**
     * @return mixed
     */
    public function getPath()
    {
        return $this->path;
    }
}