<?php
namespace IntellexApps\PHP\UploadFile\Domain\Request\File;

use IntellexApps\PHP\UploadFile\Domain\Request\ApiRequest;

/**
 * @SWG\Definition(definition="UploadFileRequest", type="object", required={"path", "base64"})
 */
class UploadRequest extends ApiRequest
{

    /**
     * @var string
     * @SWG\Property()
     */
    var $base64;

    /**
     * @var string
     * @SWG\Property()
     */
    var $path;

    /**
     * Build from request
     *
     * @param $request
     */
    protected function build($request)
    {
        $this->requireParams([
            'path', 'base64'
        ]);
        $this->path = $this->request->data['path'];
        $this->base64 = $this->request->data['base64'];
    }

    /**
     * @return mixed
     */
    public function getBase64()
    {
        return $this->base64;
    }

    /**
     * @return mixed
     */
    public function getPath()
    {
        return $this->path;
    }
}