<?php
namespace IntellexApps\PHP\UploadFile\Domain\Request\File;

use IntellexApps\PHP\UploadFile\Domain\Exception\Request\MissingParamsException;
use IntellexApps\PHP\UploadFile\Domain\Request\ApiRequest;

/**
 * @SWG\Definition(definition="MultipartUploadRequest", type="object", required={"path", "files"})
 */
class MultipartUploadRequest extends ApiRequest
{

    /**
     * @var array
     * @SWG\Property()
     */
    var $files;

    /**
     * @var string
     * @SWG\Property()
     */
    var $path;

    /**
     * Build from request
     *
     * @param $request
     * @throws MissingParamsException
     */
    protected function build($request)
    {
        $this->requireParams([
            'path'
        ]);
        $this->path = $this->request->data['path'];

        if(!isset($this->request->files['files']) || empty($this->request->files['files'])) {
            throw new MissingParamsException("files");
        }

        $this->files = $this->request->files['files'];
    }

    /**
     * @return array
     */
    public function getFiles()
    {
        return $this->files;
    }

    /**
     * @return mixed
     */
    public function getPath()
    {
        return $this->path;
    }
}