<?php
namespace IntellexApps\PHP\UploadFile\Domain\Request\File;

use IntellexApps\PHP\UploadFile\Domain\Request\ApiRequest;
use IntellexApps\PHP\UploadFile\Network\Request;
use IntellexApps\PHP\UploadFile\Util\Inflector;

/**
 * @SWG\Definition(definition="ListFilesRequest", type="object", required={"path"})
 */
class ListFilesRequest extends ApiRequest
{

    /**
     * @var string
     * @SWG\Property()
     */
    var $path;

    /**
     * Build from request
     *
     * @param Request $request
     */
    public function build(Request $request)
    {
        $this->requireParams(['path']);
        $this->setPath($request->data['path']);
    }

    /**
     * @return mixed
     */
    public function getPath()
    {
        return $this->path;
    }

    /**
     * @param mixed $path
     */
    public function setPath($path)
    {
        $path = Inflector::leadingSeparator($path);
        $this->path = $path;
    }
}

