<?php
namespace IntellexApps\PHP\UploadFile\Domain\Request;

use IntellexApps\PHP\UploadFile\Domain\Exception\NotImplementedException;
use IntellexApps\PHP\UploadFile\Domain\Exception\Request\MissingParamsException;
use IntellexApps\PHP\UploadFile\Network\Request;

class ApiRequest
{

    /** @var Request */
    var $request;

    public function __construct($request)
    {
        if($request instanceof Request) {
            $this->setRequest($request);
            $this->build($request);
        }
    }

    /**
     * Build from request
     *
     * @param $request
     * @throws NotImplementedException
     */
    protected function build($request)
    {
        throw new NotImplementedException();
    }

    /**
     * Require some params
     *
     * @param array $params
     * @throws MissingParamsException
     */
    protected function requireParams($params = [])
    {
        if(empty($this->request)) {
            return;
        }

        $missingParams = [];
        foreach($params as $param) {
            if(!array_key_exists($param, $this->getRequest()->getData())) {
                $missingParams[] = $param;
            }
        }

        if(!empty($missingParams)) {
            throw new MissingParamsException($missingParams);
        }
    }

    /**
     * @return Request
     */
    public function getRequest()
    {
        return $this->request;
    }

    /**
     * @param mixed $request
     */
    public function setRequest($request)
    {
        $this->request = $request;
    }

}