<?php
namespace IntellexApps\PHP\UploadFile\Domain\Exception\FileSystem;

use IntellexApps\PHP\UploadFile\Domain\Exception\UploadFileException;
use IntellexApps\PHP\UploadFile\Domain\Service\FileSystemService;

class InvalidPathException extends UploadFileException {

    var $code = 404;

    var $path;

    /**
     * MissingParamsException constructor.
     * @param string $path
     */
    public function __construct($path)
    {
        $this->setPath($path);
        parent::__construct(__('Invalid Path: %s', $this->getPath()));
    }

    /**
     * @return mixed
     */
    public function getPath()
    {
        return $this->path;
    }

    /**
     * @param mixed $path
     */
    public function setPath($path)
    {
        $path = FileSystemService::relativePath($path);
        $this->path = $path;
    }

}