<?php
namespace IntellexApps\PHP\UploadFile\Domain\Exception\FileSystem;

use IntellexApps\PHP\UploadFile\Domain\Exception\UploadFileException;
use IntellexApps\PHP\UploadFile\Domain\Service\FileSystemService;

class FileNotFoundException extends UploadFileException
{
    /**
     * Construct default message
     *
     * FileNotFoundException constructor.
     * @param string $path
     */
    public function __construct($path)
    {
        parent::__construct(__('File missing: %s', FileSystemService::relativePath($path)));
    }
}
