<?php
namespace IntellexApps\PHP\UploadFile\Domain\Exception\FileSystem;

use IntellexApps\PHP\UploadFile\Domain\Exception\UploadFileException;
use IntellexApps\PHP\UploadFile\Domain\Service\FileSystemService;

class FileAlreadyExistsException extends UploadFileException
{
    /**
     * Construct default message
     *
     * FileAlreadyExistsException constructor.
     * @param string $path
     */
    public function __construct($path)
    {
        parent::__construct(__('File already exists: %s', FileSystemService::relativePath($path)));
    }
}
