<?php
namespace IntellexApps\PHP\UploadFile\Domain\Exception\FileSystem;

use IntellexApps\PHP\UploadFile\Domain\Exception\UploadFileException;
use IntellexApps\PHP\UploadFile\Domain\Service\FileSystemService;

class DirectoryDoesntExistException extends UploadFileException
{
    /**
     * Construct default message
     *
     * DirectoryDoesntExistException constructor.
     * @param string $path
     */
    public function __construct($path)
    {
        parent::__construct(__('Directory missing: %s', FileSystemService::relativePath($path)));
    }
}
