<?php
namespace IntellexApps\PHP\UploadFile\Controller;

use IntellexApps\PHP\UploadFile\Domain\Model\FolderItem;
use IntellexApps\PHP\UploadFile\Domain\Request\CopyRequest;
use IntellexApps\PHP\UploadFile\Domain\Request\CreateRequest;
use IntellexApps\PHP\UploadFile\Domain\Request\DeleteRequest;
use IntellexApps\PHP\UploadFile\Domain\Request\ListFilesRequest;
use IntellexApps\PHP\UploadFile\Domain\Request\MoveRequest;
use IntellexApps\PHP\UploadFile\Domain\Request\Permission\ChangePermissionRequest;
use IntellexApps\PHP\UploadFile\Domain\Request\RenameRequest;
use IntellexApps\PHP\UploadFile\Domain\Request\UploadRequest;
use IntellexApps\PHP\UploadFile\Domain\Request\ViewItemRequest;
use IntellexApps\PHP\UploadFile\Domain\Response\StatusResponse;
use IntellexApps\PHP\UploadFile\Domain\Service\PermissionService;
use IntellexApps\PHP\UploadFile\Util\Controller;
use Swagger\Annotations as SWG;

class PermissionController extends Controller
{

    /** @var PermissionService */
    var $permissionService = null;

    /**
     * Initialize controller
     */
    protected function init()
    {
        $this->permissionService = $this->container->get('permission');
    }


    /**
     * Get roles
     *
     * TODO: Use objects here and describe with swagger
     *
     * @return array
     */

    /**
     * List files
     *
     * @SWG\Post(
     *     path="/permission/roles",
     *     description="Get all available roles ",
     *     @SWG\Response(
     *         response=200,
     *         description="Roles list",
     *         @SWG\Schema(
 *                  type="array",
 *                  @SWG\Items(ref="#/definitions/Role")
     *         )
     *
     *     ),
     *     @SWG\Response(
     *         response="default",
     *         description="unexpected error",
     *         @SWG\Schema(ref="#/definitions/ErrorModel")
     *     )
     * )
     */
    public function rolesAction()
    {
        return array_values($this->container->get('configuration')->getRoles());
    }

    /**
     * List files
     *
     * @SWG\Post(
     *     path="/permission/change",
     *     description="Change Permission for path",
     *     @SWG\Parameter(
     *         in="body",
     *         required=true,
     *         @SWG\Schema(ref="#/definitions/ChangePermissionRequest")
     *     ),
     *     @SWG\Response(
     *         response=200,
     *         description="Success response",
     *         @SWG\Schema(ref="#/definitions/StatusResponse")
     *     ),
     *     @SWG\Response(
     *         response="default",
     *         description="unexpected error",
     *         @SWG\Schema(ref="#/definitions/ErrorModel")
     *     )
     * )
     */
    public function changeAction()
    {
        $request = new ChangePermissionRequest($this->request);
        $status = $this->permissionService->changePermission(
            $request->getPath(),
            $request->getRoleId(),
            $request->getPermission()
        );

        return new StatusResponse($status);
    }
}