<?php

$routes = [];

$fileActions = [
    'upload', 'move', 'copy', 'create', 'overwrite', 'delete', 'rename', 'view', 'download'
];

foreach($fileActions as $fileAction) {
    $routes['/' . $fileAction] = '/file/' . $fileAction;
}

$routes['/list'] = '/file/listFiles';
$routes['/permissions/update'] = '/file/updatePermissions';
$routes['/download'] = '/file/download';
$routes['/thumbnail'] = '/render/thumbnail';

$routes['/iframe'] = '/render/iframe';

return [
    'routes' => $routes,
    'prefixes' => [
        '/api/v1' => function() {
            return ['version' => 1];
        }
    ]
];

