<script type="text/javascript" src="https://ajax.googleapis.com/ajax/libs/angularjs/1.4.6/angular.min.js"></script>
<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/angular.js/1.5.0-beta.0/angular-resource.min.js"></script>
<script type="text/javascript">

	var cmsApp = angular.module('cmsApp', [
		'angServices',
		'angControllers'
	]);

	var angServices = angular.module('angServices', ['ngResource']);

	// Define a resource
	cmsApp.factory('ApiFunctionResource', ['$resource', function ($resource) {
		return $resource('/wd/endpoint');
	}]);

	var angControllers = angular.module('angControllers', []);

	angControllers.controller('ApiFunctionController', ['$scope', '$resource', 'ApiFunctionResource', function ($scope, $resource, ApiFunctionResource) {

		$scope.list = ApiFunctionResource.query();

		// Show the details about an api function
		$scope.showDetails = function (api) {
			console.log(api);
		};

		$scope.refresh = function () {
			$scope.list = ApiFunctionResource.query();
		};

	}]);

</script>
<div ng-controller="ApiFunctionController">

	<div class="push side-bar">
		<h4 class="side-bar-header">&nbsp;</h4>
		<div class="side-bar-content">
			<div class="bs-docs-sidebar hidden-print hidden-xs hidden-sm affix-top" role="complementary" style="padding: 10px 0 0 20px;">
				<ul class="nav sidenav">
					<li ng-repeat="item in list">
						<a href="#" data-id="{{item.id}}" data-target="{{item.url}}" ng-click="showDetails(item)">{{item.url}}</a>
					</li>
				</ul>
			</div>
		</div>
	</div>

	<div class="push main-header with-sidebar">
		<div class="push header with-sidebar">

			<div class="push form with-sidebar" style="padding: 10px 10px 0">

			</div>
			<?php /*

		<?php
			echo $this->Format->actions(array_merge($_actions, array('<input type="text" id="QuickFilter" value="" />', '<li style="float:right;"><p id="EmptyQuickFilter" class="info warn test-api-search">' . __("No records on this page matches the supplied filter.") . '</p></li>')));
		?>

		<?php
			$this->Form->create('TestApiHeader');
			$this->Form->end();
		?>
		<!-- <form id="HeaderForm" accept-charset="utf-8" class="visible" method="POST" style="display:none"> -->
		<?= $this->Form->create('TestApiHeader', array('style' => 'display:none')); ?>
			<fieldset>
				<ul class="sortable"></ul>
			</fieldset>

			<input type="submit" value="Submit Headers" class="btn btn-success btn-large pull-right" />
		<?= $this->Form->end(); ?>
		<!-- </form> -->

		<?= $this->element('testapi/form') ?>
		<?= $this->element('testapi/group_form') ?>
	</div>

	<div class="push form with-sidebar" style="padding: 10px 10px 0">


		<div class="test">
			<script src="https://ajax.googleapis.com/ajax/libs/angularjs/1.3.14/angular.min.js"></script>



			<script type="text/javascript">
				angular.module('invoice1', [])
				.controller('InvoiceController', function() {
				  this.qty = 1;
				  this.cost = 2;
				  this.inCurr = 'EUR';
				  this.currencies = ['USD', 'EUR', 'CNY'];
				  this.usdToForeignRates = {
					USD: 1,
					EUR: 0.74,
					CNY: 6.09
				  };

				  this.total = function total(outCurr) {
					return this.convertCurrency(this.qty * this.cost, this.inCurr, outCurr);
				  };
				  this.convertCurrency = function convertCurrency(amount, inCurr, outCurr) {
					return amount * this.usdToForeignRates[outCurr] / this.usdToForeignRates[inCurr];
				  };
				  this.pay = function pay() {
					window.alert("Thanks!");
				  };
				});
			</script>


			<div ng-app="invoice1" ng-controller="InvoiceController">
			  <b>Invoice:</b>
			  <div>
				Quantity: <input type="number" min="0" ng-model="qty" required >
			  </div>
			  <div>
				Costs: <input type="number" min="0" ng-model="cost" required >
				<select ng-model="invoice.inCurr">
				  <option ng-repeat="c in invoice.currencies">{{c}}</option>
				</select>
			  </div>
			  <div>
				<b>Total:</b>
				<span>{{ qty * cost }}</span>
				<span ng-repeat="c in invoice.currencies">
				  {{invoice.total(c) | currency:c}}
				</span>
				<button class="btn btn-default" ng-click="invoice.pay()">Pay</button>
			  </div>
			</div>
		</div>

		<div class="api-test-build" style="display:none">
			<?php
				# Groups for dropdown
				$groups = ClassRegistry::init('TestApiFunctionGroup')->find('list');

				# Build enums options
				$httpTypeField = ClassRegistry::init('TestApiFunction')->schema('http_type');
				foreach($httpTypeField['enum'] as $enum) {
					$httpTypeOptions[] = $enum;
				}

				# Get enc-type enum values
				$encTypeField = ClassRegistry::init('TestApiFunction')->schema('enc_type');
			?>
			<?= $this->Form->create('TestApiFunction', array('class' => 'tabbed clearfix')) ?>
				<?php
					echo $this->Form->input('test_api_function_group_id', array('options' => $groups));
					echo $this->Form->input('name');
					echo $this->Form->input('url');
					echo $this->Form->input('http_type', array('options' => $httpTypeOptions));
				?>

				<ul class="nav nav-tabs">
					<?php $i = 0; ?>
					<?php foreach($encTypeField['enum'] as $encType) { ?>
						<li><a href="#ContentTab<?= $i == 1 ? 0 : $i ?>"><?= $encType ?></a></li>
					<?php $i++; } ?>
				</ul>

				<div class="tab" id="ContentTab0">
					<div class="input polyglot" style="">
						<ul class="sortable"></ul>
					</div>
				</div>

				<div class="tab" id="ContentTab2">
					<div class="input polyglot" style="">
						<textarea id="raw-text" name="" maxlength="200" type="text"></textarea>
					</div>
				</div>

				<?= $this->Form->button('Execute', array('id' => 'submit', 'class' => 'btn btn-primary', 'name' => 'execute', 'style' => 'display:block; margin-right:1em; float:left; margin: 5px 5px 5px 165px;', 'type' => 'button')); ?>

			<?= $this->Form->close(__('Save'), false, 'check') ?>
		</div>

		<div class="col-md-12" style="padding-top:12px;">

			<button class="btn btn-danger clear" style="display:none" role="button" id="Clear" onclick="$('#Results').html(''); $(this).hide();">Clear results</button>
			<img src="/img/ico/loader_small.gif" id="Loader" style="display:none" />

			<hr />

			<section id="Results" style="display:block"></section>
		</div>
		*/ ?>
		</div>

	</div>

	<script type="text/javascript" src="http://underscorejs.org/underscore-min.js"></script>
	<script type="text/javascript" src="https://intellex.rs/json_painter/jquery.jsonPainter-x.js"></script>
	<script type="text/javascript">
		var fieldCounter = 0;

		// For selecting value inside dropdown box
		function setSelectValue(id, val) {
			document.getElementById(id).value = val;
		}

		// Reordering group functions
		function reorder(row, position) {

			// Send request ASD
			/*
					$.ajax({
						url:		"<?= $this->Html->url([ P => null, A => 'function_reorder' ]) ?>",
			dataType:	"json",
			type:		"POST",
			data: {
				"id":		row.find('a').attr("data-id"),
				"model":	row.parent().attr('data-model'),
				"group_id":	row.parent().parent().find('h4').attr('data-id'),
				"ordering":	position },
			success : function(data) {},
			error : function() {}
		});
*/
		}

		// Transfer data from tab to tab
		function equalContent() {
			$(document).on('keyup', 'form div.tab ul.sortable li input:text, form div.tab textarea', function () {
				var activeDiv = $(this).parentsUntil('form div.tab').last().parent();

				// Find input fields of active div and create array data
				var encTypeData = [];
				if ($(activeDiv).find('ul.sortable').length > 0) {
					$(activeDiv).find('ul.sortable li.custom').each(function () {
						var name = $('.field-name', $(this)).val().replace('[', '(').replace(']', ')');
						var value = $('.field-value', $(this)).val();
						if (name != '') {
							encTypeData.push(name + "=" + value);
						}
					});
				} else {
					encTypeData.push($(activeDiv).find('#raw-text').val());
				}

				// Iterate over each tab
				activeDiv.siblings('.tab').each(function () {
					$this = $(this);
					var rawVal = '';

					// Check witch tab is active based on textarea field
					if ($this.find('textarea').length > 0) {

						// Populate data for textarea value
						$.each(encTypeData, function (i) {
							rawVal += i + 1 == encTypeData.length ? encTypeData[i] : encTypeData[i] + '&';
						});

						// Add value to textarea
						$this.find('textarea').val(rawVal);
					} else {

						// Clear all fields
						$(this).find('ul.sortable li.fn').remove();

						// Check from witch tab is data
						if (encTypeData[0].indexOf('&') != -1) {

							// Split data to rows
							var encTypeRows = encTypeData[0].split('&');

							$.each(encTypeRows.reverse(), function (i) {

								// Split each row to name and value
								var rowValues = encTypeRows[i].split('=');

								// Add new row
								$this.find('ul.sortable').prepend('<li class="custom input fn"><input type="text" class="field-name" value="' + rowValues[0] + '"><input type="text" class="field-value" value="' + (encTypeRows[i].indexOf('=') != -1 ? rowValues[1] : '') + '"></li>');
							});

						} else {
							$.each(encTypeData.reverse(), function (i) {

								// Split each row to name and value
								var rowValues = encTypeData[i].split('=');

								// Add new row
								$this.find('ul.sortable').prepend('<li class="custom input fn"><input type="text" class="field-name" value="' + rowValues[0] + '"><input type="text" class="field-value" value="' + (encTypeData[i].indexOf('=') != -1 ? rowValues[1] : '') + '"></li>');
							});
						}
					}
				});
			});
		}

		// Load data by AJAX
		/*
			$('form#TestApiFunctionIndexForm').find('button#submit').click(function() {
				var mainForm = $('form#TestApiFunctionIndexForm');
				var headerForm = $('form#TestApiHeaderIndexForm');
				var clear = $('#Clear');
				var section = $('#Results');

				$('#Loader').show();
				section.html('');
				clear.hide();

				// Load
				$.post('/basetest/execute', 'envId' + '=' + $('form#envActions').find('ul li').first().find('a.env-edit').attr('data-id') + '&' + 'encType' + '=' + $('.nav-tabs').find('li.active a').text() + '&' + 'body' + '=' + $(this).parent().find('textarea').val().replace(/&/g, '%26') + '&' + headerForm.serialize() + '&' + mainForm.serialize(), function(response) {
					section.html(response);
					section.find('.response').jsonPainter();
					$('#Loader').hide();
					clear.show();
				});

				return false;
			});
		*/

		// AJAX function edit
		window.initializeApiListClick = function () {
			$('div.side-bar').find('ul.nav li a').each(function () {

				$(this).off('click').click(function () {

					// Function id
					var functionId = $(this).attr('data-id');

					// Get values from model
					/*
									$.ajax({
										url : "<?= '/' . $locale . '/' ?>test/get_api_function/",
					dataType : "json",
					type : "POST",
					data : {'fnId' : functionId},
					success : function(data) {

						if(data.length) {
							$.each(data, function(i) {

								// Set id of item
								$('form#TestApiFunctionIndexForm').attr('data-id', data[i].id);

								// Set value of dropdown
								setSelectValue('TestApiFunctionTestApiFunctionGroupId', data[i].group_id);

								// Set other values
								$('#TestApiFunctionName').val(data[i].name);
								$('#TestApiFunctionUrl').val(data[i].url);

								// Set selected text of Http type
								$("#TestApiFunctionHttpType option:contains(" + data[i].http_type + ")").attr('selected', 'selected');

								// Open appropriate tab and fill input fields
								$('ul.nav-tabs').find('li').each(function() {
									if($(this).text() == data[i].enc_type) {
										$(this).find('a').trigger('click')
									}
								});

								// Check where to put body text or items
								$('div#ContentTab0').find('ul.sortable li.fn').remove();
								$('#raw-text').val('');

								// Fill textarea field with data
								$('#raw-text').val(data[i].raw_body);

								// Fill each text field with data
								$.each(data[i].body, function(name, value) {
									$('div#ContentTab0 ul.sortable').prepend('<li class="custom input fn"><input type="text" class="field-name" value="' + name + '"><input type="text" class="field-value" value="' + value + '"></li>');
									$('div#ContentTab1 ul.sortable').prepend('<li class="custom input fn"><input type="text" class="field-name" value="' + name + '"><input type="text" class="field-value" value="' + value + '"></li>')
								});

							});
						}
					},
					error : function() {}
				});
*/

					// Display edit form if it is hidden
					if (!$('form#TestApiFunctionIndexForm').is(":visible")) {
						$('.api-test-build').fadeIn();
					}
				});
			});
		};
		/*////////////////////////////////////
			function ParamsList(currentList) {
				var $this = this;

				var list = [];

				$this.put = function(param, value) {
					// redraw other tabs
					list.push({param : value};
				}

				$this.delete = function(param) {
					// redraw other tabs
					if(list[param]) {
						delete list[param];
					}
				}

				$this.getList = function() {
					return list;
				}


				if(currentList) {
					list = currentList;
					// Redraw all
				}
			}

			var paramsList = new ParamsList();

			paramsList.put('1', '2');
		//////////////////////////////////////////////*/

		$(function () {

			// Transfer data from tab to tab
			equalContent();

			// Show/hide api form
			$('.fa-plus').parent().click(function (e) {
				$('.api-test-build').fadeToggle(function () {
					$('form#TestApiFunctionIndexForm')[0].reset();
					$('form#TestApiFunctionIndexForm').attr('data-id', '');
					$('div#ContentTab0').find('ul.sortable li.fn').remove();
				});
				e.preventDefault();
			});

			// Some tabs
			$('.nav-tabs a').click(function () {
				$('.tab').hide();
				$($(this).attr('href')).show();
				$(this).closest('li').addClass('active').siblings().removeClass('active');
				$('.add-field').toggle($('#FieldTab').is(':visible'));
				return false;
			});
			$('.nav-tabs:not(.polyglot-tabs) a:first').click();

			// Sorting sidebar links
			$('.nav-sidebar, .group-header').sortable({
				axis: 'y',
				//handle: '.setter',
				placeholder: 'ui-state-highlight',
				stop: function (event, ui) {
					reorder(ui.item, ui.item.prevAll().length + 1);
				},
				start: function (event, ui) {
				}
			});

			// Sortable fields
			$('.sortable').sortable({
				axis: 'y'
			});

			// Get headers on page load
			/*
					$.ajax({
						url : "<?= '/' . $locale . '/' ?>test/get_headers/",
			dataType : "json",
			type : "POST",
			success : function(data) {
				if(data.objects.length) {
					$.each(data.objects, function(i) {
						CustomForm.addField($('#TestApiHeaderIndexForm'), data.objects[i].name, data.objects[i].value, 'headers');
					});
				}
				CustomForm.addField($('#TestApiHeaderIndexForm'), null, null, 'headers');
			},
			error : function() {}
		});
*/

			// Get details for each api function
			initializeApiListClick();

		});

		// AJAX submit header form
		$('#TestApiHeaderIndexForm').submit(function () {
			return CustomForm.submit($(this));
		});

		// AJAX submit function form
		$('#TestApiFunctionIndexForm').submit(function () {

			var functionData = [];

			var funcId = $('form#TestApiFunctionIndexForm').attr('data-id');
			var groupId = $('#TestApiFunctionTestApiFunctionGroupId').val();
			var name = $('#TestApiFunctionName').val();
			var url = $('#TestApiFunctionUrl').val();
			var httpType = $('#TestApiFunctionHttpType option:selected').text();
			var encType = $('.nav-tabs').find('li.active a').text();

			if (name.length > 0 || url.length > 0) {
				functionData.push({'id': funcId});
				functionData.push({'groupId': groupId});
				functionData.push({'name': name});
				functionData.push({'url': url});
				functionData.push({'httpType': httpType});
				functionData.push({'encType': encType});

				var activeDiv = $('.nav-tabs').find('li.active a').attr('href');

				// Find input fields of active div
				//var encTypeData = [];
				/*if($(activeDiv).find('ul.sortable').length > 0) {
					$(activeDiv).find('ul.sortable li.custom').each(function() {
						var name = $('.field-name', $(this)).val().replace('[', '(').replace(']', ')');
						var value = $('.field-value', $(this)).val();
						if(name != '') {
							encTypeData.push(name + "=" + value);
						}
					});
				} else {
					encTypeData.push($(activeDiv).find('#raw-text').val());
				}*/

				// Add textarea content to data for sending
				// Prepare all data for sending
				functionData.push({'encTypeData': $(activeDiv).find('#raw-text').val()});

				// Send request
				$.ajax({
					url: "<?= '/' . $locale . '/' ?>test/save_api_function/",
					dataType: "json",
					type: "POST",
					data: {"fnData": functionData},
					success: function (data) {
						if (data.response) {
							alert('Function is saved!');

							if (!$('h4[data-id=' + groupId + ']').is(':visible')) {
								$('h4[data-id=' + groupId + ']').parent().append('<ul class="nav"></ul>');
								$('h4[data-id=' + groupId + ']').show();
							}
							if (data.fnId != funcId) {
								$('h4[data-id=' + groupId + ']').parent().find('ul.nav').append('<li><a href="#" data-id="' + data.fnId + '" data-target="' + url + '">' + name.toLowerCase() + '</a></li>');

								// Init click on api function
								initializeApiListClick();
							} else {
								$('h4[data-id=' + groupId + ']').parent().find('a[data-id=' + funcId + ']').attr('data-target', url).text(name.toLowerCase());
							}
						}
					},
					error: function () {
					}
				});
			} else {
				alert('Enter name and URL!');
			}

			return false;
		});


		CustomForm = {

			addField: function ($wrapper, name, value, group) {

				if (!group) group = 'base';

				if (!$wrapper.data('fieldCounter')) {
					$wrapper.data('fieldCounter', 0);
				}

				var fieldCounter = $wrapper.data('fieldCounter') + 1;

				var label = $('<input type="text" class="field-name group">')
					.attr('name', 'fields[' + group + '][' + fieldCounter + '][name]')
					.attr('data-group', group)
					.val(name);
				var input = $('<input type="text" class="field-value">')
					.attr('name', 'fields[' + group + '][' + fieldCounter + '][value]')
					.val(value);

				label.keyup(function () {

					// Add field
					if ($wrapper.find('.field-name').filter(function () {
							return $(this).val() == "";
						}).length == 0) {
						label.parent().addClass('fn');
						CustomForm.addField($wrapper, null, null, label.attr('data-group'));

						// Transfer data from tab to tab
						equalContent();

						return true;
					}

					// Remove field
					var emptyOnes = $wrapper.find('.field-name').filter(function () {
						return $(this).val() == "";
					});
					if ($(this).val() == '' && emptyOnes.length > 1) {
						$(this).parent().remove();
						$(emptyOnes[emptyOnes.length - 1]).focus();
						return true;
					}
				});

				var item = $wrapper.selector == '#group-sorted' ? $('<li class="custom input" style="display:none">').append(label) : $('<li class="custom input" style="display:none">').append(label).append(input);
				$wrapper.find('ul').append(item);
				item.fadeIn();
				$wrapper.data('fieldCounter', fieldCounter);
			},

			submit: function (form) {
				var headers = [];
				$('li.custom').each(function () {
					var name = $('.field-name', $(this)).val().replace('[', '(').replace(']', ')');
					var value = $('.field-value', $(this)).val();
					if (name != '') {
						headers.push(name + "-" + value);
					}
				});

				// Send request
				$.ajax({
					url: "<?= '/' . $locale . '/' ?>test/save_headers/",
					dataType: "json",
					type: "POST",
					data: {"headers": headers},
					success: function (response) {
						if (response) {
							alert('Headers are updated!');
						}
					},
					error: function () {
					}
				});
				return false;
			}
		};
		CustomForm.addField($('#ContentTab0'), null, null, 'enctype');
		CustomForm.addField($('#sorted'), null, null, 'form');
		CustomForm.addField($('#group-sorted'), null, null, 'group');

		///////////////	////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		// Show the form
		$('.sidenav a').click(function () {
			$('form.api').hide();
			$('form.api[rel="' + $(this).data('target') + '"]').show();
			$('.sidenav li.active').removeClass('active');
			$(this).closest('li').addClass('active');
		});

		// Click on the first tab
		jQuery('.sidenav a:first').click();

		// Submit form
		$('#Submit').click(function () {
			$('form.api:visible').submit();
		});

		// Load data by AJAX
		$('form#api').submit(function () {
			var form = $(this);
			var clear = $('#Clear');
			var section = $('#Results');

			$('#Loader').css('visibility', 'auto');
			section.html('');
			clear.hide();

			// Load
			$.post('/basetest/execute', $('form#mandatory').serialize() + '&' + form.serialize(), function (response) {
				section.html(response);
				section.prepend('<h3>Results:</h3>');
				section.find('.response').jsonPainter();
				$('#Loader').css('visibility', 'hidden');
				clear.show();
			});

			return false;
		});
		// >>>>>>>>>>>>>>>>>>>>>>>>>>> EOF api test


		// >>>>>>>>>>>>>>>>>>>>>>>>>>> Search
		// Quick filter
		$("#QuickFilter").focus().select().bind('input propertychange', function () {

			// When value of the input is not blank
			if ($(this).val() != "") {
				$("div.bs-docs-sidebar ul > li").hide();
				$("div.bs-docs-sidebar ul li:contains-ci('" + $(this).val() + "')").show();

				// Handle empty results
				if (!$("div.bs-docs-sidebar ul > li:visible").size()) {
					$('#EmptyQuickFilter').show();
				} else {
					$('#EmptyQuickFilter').hide();
				}

				// When there is no input or clean again, show everything back
			} else {
				$("div.bs-docs-sidebar ul > li").show();
				$('#EmptyQuickFilter').hide();
			}
		});

		// Case insensitive contains
		$.extend($.expr[":"], {
			"contains-ci": function (elem, i, match, array) {
				return (elem.textContent || elem.innerText || $(elem).text() || "").toLowerCase().indexOf((match[3] || "").toLowerCase()) >= 0;
			}
		});
		// >>>>>>>>>>>>>>>>>>>>>>>>>>> EOF Search

		// Toggle header
		function toggleHeader() {
			$('#TestApiHeaderIndexForm').toggle('slow');
		}

	</script>
</div>
