<script type="text/javascript" src="/plugins/angular-1.4.7/angular.js"></script>
<script type="text/javascript" src="/plugins/angular-1.4.7/angular-resource.js"></script>
<script type="text/javascript">
	'use strict';

	var cmsApp = angular.module('ngCMS', [
		'ngResource',

		'ConfigurationResource',
		'HeaderResource',
		'EnvironmentResource',
		'FunctionResource',
		'CollectionResource',

		'WatchDogController'
	]);

	angular.element(document).ready(function () {
		angular.bootstrap(document, ['ngCMS']);
	});

	var angControllers = angular.module('angControllers', []);

	// var angServices = angular.module('angServices', ['ngResource']);

	// Resource: The list of groups

	/*
		cmsApp.factory('InitResource', ['$resource', function($resource) {
			return $resource('/wd/endpoint/init');
		}]);
	*/


	angular.module('InitResource', [])
		.factory('InitResource', ['$resource', function ($resource) {
			return $resource('/wd/endpoint/init');
		}]);

	angular.module('ConfigurationResource', [])
		.factory('ConfigurationResource', ['$resource', function ($resource) {
			return $resource('/wd/endpoint/configuration');
		}]);

	angular.module('HeaderResource', [])
		.factory('HeaderResource', ['$resource', function ($resource) {
			return $resource('/wd/endpoint/header');
		}]);

	angular.module('EnvironmentResource', [])
		.factory('EnvironmentResource', ['$resource', function ($resource) {
			return $resource('/wd/endpoint/environment');
		}]);

	angular.module('FunctionResource', [])
		.factory('FunctionResource', ['$resource', function ($resource) {
			return $resource('/wd/endpoint/function');
		}]);

	angular.module('CollectionResource', [])
		.factory('CollectionResource', ['$resource', function ($resource) {
			return $resource('/wd/endpoint/collection');
		}]);

	angular.module('WatchDogController', [])
		.controller('WatchDogController', ['$scope', 'ConfigurationResource', 'HeaderResource', 'EnvironmentResource', 'FunctionResource', 'CollectionResource', function ($scope, ConfigurationResource, HeaderResource, EnvironmentResource, FunctionResource, CollectionResource) {

			// Load
			$scope.selectedFunction = null;
			$scope.configuration = ConfigurationResource.get();
			$scope.header = HeaderResource.query();
			$scope.environment = EnvironmentResource.query();
			$scope.groups = FunctionResource.query();
			$scope.collections = CollectionResource.query();

			// Show the details about an api function
			$scope.showDetails = function (api) {
				$scope.selectedFunction = api;
			};

			// Check if the selected function has request body
			$scope.methodsWithoutBody = ['GET', 'DELETE', 'HEAD'];
			$scope.hasRequestBody = function () {

				// No function is selected
				if (this.selectedFunction == null) {
					return false;
				}

				// Check the method
				for (var _ in this.methodsWithoutBody) {
					if (this.selectedFunction.http_method == this.methodsWithoutBody[_]) {
						return false;
					}
				}
				return true;
			};

			// Add the environment variable
			$scope.addVariable = function (model) {
				model = model.toLowerCase();
				$scope[model].push({
					name: '',
					value: '',
					comment: ''
				});
			};

			// Remove the variable from the list
			$scope.removeVariable = function (model, variable, options) {
				model = model.toLowerCase();
				var variables = $scope[model];

				// Handle special cases
				for (var option in options) {
					switch (option) {

						// Specific model name
						case 'model':
							model = options[option];
							break;

						// Variables reside in a deeper path
						case 'key':
							variables = $scope[model][options[option]]
					}
				}

				var index = variables.indexOf(variable);
				variables.splice(index, 1);
			};

			// Save the enviroment
			$scope.saveVariables = function (model, options) {
				if (!$scope[saving]) {

					// Prepare pointers
					var resource = null;
					eval('resource = ' + model + 'Resource;');
					model = model.toLowerCase();
					var saving = model + 'Saving';

					// Handle special cases
					for (var option in options) {
						switch (option) {

							// Specific model name
							case 'model':
								model = options[option];
						}
					}

					// Show the spinner while the data is saved
					$scope[saving] = true;
					resource.save($scope[model], function (response) {
						$scope[saving] = false;

						// Handle errors
						if (response.success) {
							nxDialog.hide();
						} else {
							alert(<?= json_encode(__('An error occurred!')) ?> +"\n\n" + <?= json_encode(__('Changes have not been saved.')) ?>);
						}
					});
				}
			};
		}]);

</script>
<div>

	<div ng-controller="WatchDogController">

		<div class="push side-bar">
			<h4 class="side-bar-header"><?= __('Available functions') ?>
				<a ng-click="refresh()"><i class="fa fa-refresh"></i></a></h4>
			<div class="side-bar-content">
				<div class="available bs-docs-sidebar hidden-print hidden-xs hidden-sm affix-top" role="complementary" style="padding: 10px 0 0 20px;">
					<ul ng-show="groups" class="nav sidenav groups ng-hide">
						<li ng-repeat="group in groups">
							<span ng-if="group.id" data-id="{{group.id}}" data-target="{{group.name}}">{{group.name}}</span>

							<ul class="nav sidenav functions">
								<li ng-repeat="function in group.functions">
									<a href="#" class="sortable-handle function" data-id="{{function.id}}" data-target="{{function.url}}" ng-click="showDetails(function)">{{function.url}}</a>
								</li>
							</ul>
						</li>
					</ul>
				</div>
			</div>
		</div>

		<script type="text/javascript">
			$(document).ready(function () {
				$('.available .sidenav.groups, .available .sidenav.functions').sortable({
					handle: '.handle',
					axis: 'y'
				});
				$('.nxdialog-trigger').nxDialog();
			});
		</script>

		<div class="push main-header with-sidebar">
			<div class="push header with-sidebar">

				<?php echo $this->Format->actions($_actions) ?>

			</div>

			<div ng-show="selectedFunction" class="container-fluid ng-hide">

				<div class="row ng-hide" ng-show="selectedFunction.description">

					<div class="col-xs-12">
						<p class="well">
							{{selectedFunction.description}}
						</p>
					</div>

				</div>

				<div class="row">

					<div class="col-xs-2">
						{{selectedFunction.http_method}}
					</div>

					<div class="col-xs-10">
						{{selectedFunction.url}}
					</div>

				</div>

				<div class="row" ng-show="hasRequestBody()">

					<div class="col-xs-2">
						<?= __('Data') ?>
					</div>

					<div class="col-xs-8">
						{{selectedFunction.enc_type}}
					</div>

					<ul class="row">

					</ul>

				</div>

				<div class="row">

					<div class="col-xs-12">
						<a href="#EditFunction" class="btn btn-default pull-right nxdialog-trigger"><?= __('Edit') ?></a>
					</div>

				</div>
			</div>

			<div ng-show="!selectedFunction" class="container-fluid ng-hide">
				<div class="row">

					<div class="col-xs-12 ng-hide" ng-show="!configuration.specification">
						<p class="well">
							<?= __('API specification is not available.') ?>
						</p>
					</div>

					<div class="col-xs-12 ng-hide" ng-show="configuration.specification">
						<p class="well">
							<?= __('API specification can be found here:') ?>
							<a href="{{configuration.specification}}" target="_blank">{{configuration.specification}}</a>.
						</p>
					</div>

					<div class="col-xs-12 ng-hide" ng-show="configuration.info">
						<pre>{{configuration.info}}</pre>
					</div>

					<div class="col-xs-12">
						<a href="#EditConfiguration" class="btn btn-default pull-right nxdialog-trigger"><?= __('Edit') ?></a>
					</div>
				</div>
			</div>

			<div class="dialog-parent clearfix" id="EditFunction" style="display: none">
				<h1><?= __('Edit API function') ?></h1>

				<div class="dialog-inner">
					<form class="container-fluid">

						<div class="row">
							<div class="col-xs-6 col-md-2">
								<label><?= __('HTTP Method') ?></label>
							</div>

							<div class="col-xs-6 col-md-4">
								<div class="input">
									<select ng-model="selectedFunction.http_method" title="<?= __('HTTP Method') ?>">
										<?php foreach ($httpMethods as $method) { ?>
											<option name="<?= $method ?>"><?= $method ?></option>
										<?php } ?>
									</select>
								</div>
							</div>

							<div class="col-xs-6 col-md-2 ng-hide" ng-show="hasRequestBody()">
								<label><?= __('Encoding type') ?></label>
							</div>

							<div class="col-xs-6 col-md-4 ng-hide" ng-show="hasRequestBody()">
								<div class="input">
									<select ng-model="selectedFunction.enc_type" title="<?= __('Encoding type') ?>">
										<?php foreach ($encTypes as $type) { ?>
											<option name="<?= $type ?>"><?= $type ?></option>
										<?php } ?>
									</select>
								</div>
							</div>
						</div>

						<div class="row">
							<div class="col-xs-6 col-md-2">
								<label><?= __('Function URL') ?></label>
							</div>

							<div class="col-xs-6 col-md-4">
								<div class="input">
									<input ng-model="selectedFunction.url" placeholder="<?= __('Function URL') . ' (' . __('without base URL') . ')' ?>" title="<?= __('Function URL') . '(' . __('wihtout base URL') . ')' ?>" />
								</div>
							</div>

							<div class="col-xs-6 col-md-2">
								<label><?= __('Collection') ?></label>
							</div>

							<div class="col-xs-6 col-md-4">
								<div class="input">
									<select ng-model="selectedFunction.function_collection_id" ng-options="collection as collection.name for collection in collections track by collection.id" title="<?= __('Collection') ?>"></select>
								</div>
							</div>
						</div>

						<div class="row">
							<div class="col-xs-12 col-md-2">
								<label><?= __('Description') ?></label>
							</div>

							<div class="col-xs-12 col-md-10">
								<div class="input">
									<textarea ng-model="selectedFunction.description" placeholder="<?= __('Additional decription and information about the function') ?>" title="<?= __('Additional decription and information about the function') ?>"></textarea>
								</div>
							</div>
						</div>

						<ul class="clearfix listing sortable ng-hide" ng-show="hasRequestBody()">
							<li ng-repeat="var in selectedFunction.params" class="row clearfix">
								<div class="col-xs-12 col-md-4">
									<div class="input">
										<input ng-model="var.name" placeholder="<?= __('Key') ?>" title="<?= __('Key') ?>" />
									</div>
								</div>

								<div class="col-xs-10 col-md-7">
									<div class="input">
										<input ng-model="var.value" placeholder="<?= __('Default value') ?>" title="<?= __('Default value') ?>" />
									</div>
								</div>

								<div class="col-xs-1">
									<a ng-click="removeVariable('Function', var, { model: 'selectedFunction', key: 'params' })" href="#Remove" class="listing-valign listing-remove left clear-none"><i class="fa fa-fw fa-trash"></i></a>
								</div>
							</li>

							<li class="row">
								<div class="col-xs-12">
									<a ng-click="addVariable('Function')" href="#Add" class="listing-valign listing-add"><i class="fa fa-fw fa-plus"></i> <?= __('Add parameter') ?>
									</a>
								</div>
							</li>
						</ul>

						<div class="row">
							<div class="col-xs-12 text-center">
								<button type="submit" ng-click="saveVariables('Function', { model: 'selectedFunction' })" href="#Save" class="btn btn-primary btn-center">
									<i class="fa fa-fw fa-{{functionSaving ? 'spinner fa-spin' : 'save' }}"></i>
									<?= __('Save changes') ?>
								</button>
							</div>
						</div>
					</form>
				</div>
			</div>

			<div class="dialog-parent clearfix" id="EditConfiguration" style="display: none">
				<h1><?= __('Global API configuration') ?></h1>

				<div class="dialog-inner">
					<form class="container-fluid">
						<div class="row">

							<div class="col-xs-12 col-md-2">
								<label><?= __('URL to API specification') ?></label>
							</div>

							<div class="col-xs-12 col-md-10">
								<div class="input">
									<input ng-model="configuration.specification" placeholder="<?= __('API specification') ?>" title="<?= __('URL to API specification') ?>" />
								</div>
							</div>
						</div>

						<div class="row">

							<div class="col-xs-12 col-md-2">
								<label><?= __('Additional information') ?></label>
							</div>

							<div class="col-xs-12 col-md-10">
								<div class="input">
									<textarea rows="8" ng-model="configuration.info" placeholder="<?= __('Additional decription and information about the API') ?>" title="<?= __('Additional decription and information about the API') ?>"></textarea>
								</div>
							</div>
						</div>

						<div class="row">
							<div class="col-xs-12 text-center">
								<button type="submit" ng-click="saveVariables('Configuration')" href="#Save" class="btn btn-primary btn-center">
									<i class="fa fa-fw fa-{{configurationSaving ? 'spinner fa-spin' : 'save' }}"></i>
									<?= __('Save') ?>
								</button>
							</div>
						</div>
					</form>
				</div>
			</div>

			<?php foreach ([ 'Header', 'Environment' ] as $model) { ?>
				<div class="dialog-parent clearfix" id="Edit<?= $model ?>" style="display: none">
					<h1><?= __($model) ?></h1>

					<div class="dialog-inner">
						<form class="container-fluid">
							<ul class="clearfix listing sortable">
								<li ng-repeat="var in <?= strtolower($model) ?>" class="row clearfix">

									<div class="col-xs-12 col-md-4">
										<div class="input">
											<input ng-model="var.name" placeholder="<?= __('Key') ?>" title="<?= __('Key') ?>" />
										</div>
									</div>

									<div class="col-xs-10 col-md-7">
										<div class="input">
											<input ng-model="var.value" placeholder="<?= __('Value') ?>" title="<?= __('Value') ?>" />
										</div>
									</div>

									<div class="col-xs-1">
										<a ng-click="removeVariable('<?= $model ?>', var)" href="#Remove" class="listing-valign listing-remove left clear-none"><i class="fa fa-fw fa-trash"></i></a>
									</div>
								</li>

								<li class="row">
									<div class="col-xs-12">
										<a ng-click="addVariable('<?= $model ?>')" href="#Add" class="listing-valign listing-add"><i class="fa fa-fw fa-plus"></i> <?= __('Add %s variable', strtolower($model)) ?>
										</a>
									</div>
								</li>
							</ul>

							<div class="row">
								<div class="col-xs-12 text-center">
									<button type="submit" ng-click="saveVariables('<?= $model ?>')" href="#Save" class="btn btn-primary btn-center">
										<i class="fa fa-fw fa-{{<?= strtolower($model) ?>Saving ? 'spinner fa-spin' : 'save' }}"></i>
										<?= __('Save') ?> <?= __(strtolower($model)) ?>
									</button>
								</div>
							</div>
						</form>
					</div>
				</div>
			<?php } ?>

			<?php /*
			<?php
				$this->Form->create('TestApiHeader');
				$this->Form->end();
			?>
			<!-- <form id="HeaderForm" accept-charset="utf-8" class="visible" method="POST" style="display:none"> -->
			<?= $this->Form->create('TestApiHeader', array('style' => 'display:none')); ?>
				<fieldset>
					<ul class="sortable"></ul>
				</fieldset>

				<input type="submit" value="Submit Headers" class="btn btn-success btn-large pull-right" />
			<?= $this->Form->end(); ?>
			<!-- </form> -->

			<?= $this->element('testapi/form') ?>
			<?= $this->element('testapi/group_form') ?>
		</div>

		<div class="push form with-sidebar" style="padding: 10px 10px 0">


			<div class="test">
				<script src="https://ajax.googleapis.com/ajax/libs/angularjs/1.3.14/angular.min.js"></script>



				<script type="text/javascript">
					angular.module('invoice1', [])
					.controller('InvoiceController', function() {
					  this.qty = 1;
					  this.cost = 2;
					  this.inCurr = 'EUR';
					  this.currencies = ['USD', 'EUR', 'CNY'];
					  this.usdToForeignRates = {
						USD: 1,
						EUR: 0.74,
						CNY: 6.09
					  };

					  this.total = function total(outCurr) {
						return this.convertCurrency(this.qty * this.cost, this.inCurr, outCurr);
					  };
					  this.convertCurrency = function convertCurrency(amount, inCurr, outCurr) {
						return amount * this.usdToForeignRates[outCurr] / this.usdToForeignRates[inCurr];
					  };
					  this.pay = function pay() {
						window.alert("Thanks!");
					  };
					});
				</script>


				<div ng-app="invoice1" ng-controller="InvoiceController">
				  <b>Invoice:</b>
				  <div>
					Quantity: <input type="number" min="0" ng-model="qty" required >
				  </div>
				  <div>
					Costs: <input type="number" min="0" ng-model="cost" required >
					<select ng-model="invoice.inCurr">
					  <option ng-repeat="c in invoice.currencies">{{c}}</option>
					</select>
				  </div>
				  <div>
					<b>Total:</b>
					<span>{{ qty * cost }}</span>
					<span ng-repeat="c in invoice.currencies">
					  {{invoice.total(c) | currency:c}}
					</span>
					<button class="btn btn-default" ng-click="invoice.pay()">Pay</button>
				  </div>
				</div>
			</div>

			<div class="api-test-build" style="display:none">
				<?php
					# Groups for dropdown
					$groups = ClassRegistry::init('TestApiFunctionGroup')->find('list');

					# Build enums options
					$httpTypeField = ClassRegistry::init('TestApiFunction')->schema('http_type');
					foreach($httpTypeField['enum'] as $enum) {
						$httpTypeOptions[] = $enum;
					}

					# Get enc-type enum values
					$encTypeField = ClassRegistry::init('TestApiFunction')->schema('enc_type');
				?>
				<?= $this->Form->create('TestApiFunction', array('class' => 'tabbed clearfix')) ?>
					<?php
						echo $this->Form->input('test_api_function_group_id', array('options' => $groups));
						echo $this->Form->input('name');
						echo $this->Form->input('url');
						echo $this->Form->input('http_type', array('options' => $httpTypeOptions));
					?>

					<ul class="nav nav-tabs">
						<?php $i = 0; ?>
						<?php foreach($encTypeField['enum'] as $encType) { ?>
							<li><a href="#ContentTab<?= $i == 1 ? 0 : $i ?>"><?= $encType ?></a></li>
						<?php $i++; } ?>
					</ul>

					<div class="tab" id="ContentTab0">
						<div class="input polyglot" style="">
							<ul class="sortable"></ul>
						</div>
					</div>

					<div class="tab" id="ContentTab2">
						<div class="input polyglot" style="">
							<textarea id="raw-text" name="" maxlength="200" type="text"></textarea>
						</div>
					</div>

					<?= $this->Form->button('Execute', array('id' => 'submit', 'class' => 'btn btn-primary', 'name' => 'execute', 'style' => 'display:block; margin-right:1em; float:left; margin: 5px 5px 5px 165px;', 'type' => 'button')); ?>

				<?= $this->Form->close(__('Save'), false, 'check') ?>
			</div>

			<div class="col-md-12" style="padding-top:12px;">

				<button class="btn btn-danger clear" style="display:none" role="button" id="Clear" onclick="$('#Results').html(''); $(this).hide();">Clear results</button>
				<img src="/img/ico/loader_small.gif" id="Loader" style="display:none" />

				<hr />

				<section id="Results" style="display:block"></section>
			</div>
			*/ ?>

		</div>

		<div

		<script type="text/javascript" src="http://underscorejs.org/underscore-min.js"></script>
		<script type="text/javascript" src="https://intellex.rs/json_painter/jquery.jsonPainter-x.js"></script>
		<script type="text/javascript">
			var fieldCounter = 0;

			// For selecting value inside dropdown box
			function setSelectValue(id, val) {
				document.getElementById(id).value = val;
			}

			// Reordering group functions
			function reorder(row, position) {

				// Send request ASD
				/*
						$.ajax({
							url:		"<?= $this->Html->url([ P => null, A => 'function_reorder' ]) ?>",
				dataType:	"json",
				type:		"POST",
				data: {
					"id":		row.find('a').attr("data-id"),
					"model":	row.parent().attr('data-model'),
					"group_id":	row.parent().parent().find('h4').attr('data-id'),
					"ordering":	position },
				success : function(data) {},
				error : function() {}
			});
	*/
			}

			// Transfer data from tab to tab
			function equalContent() {
				$(document).on('keyup', 'form div.tab ul.sortable li input:text, form div.tab textarea', function () {
					var activeDiv = $(this).parentsUntil('form div.tab').last().parent();

					// Find input fields of active div and create array data
					var encTypeData = [];
					if ($(activeDiv).find('ul.sortable').length > 0) {
						$(activeDiv).find('ul.sortable li.custom').each(function () {
							var name = $('.field-name', $(this)).val().replace('[', '(').replace(']', ')');
							var value = $('.field-value', $(this)).val();
							if (name != '') {
								encTypeData.push(name + "=" + value);
							}
						});
					} else {
						encTypeData.push($(activeDiv).find('#raw-text').val());
					}

					// Iterate over each tab
					activeDiv.siblings('.tab').each(function () {
						$this = $(this);
						var rawVal = '';

						// Check witch tab is active based on textarea field
						if ($this.find('textarea').length > 0) {

							// Populate data for textarea value
							$.each(encTypeData, function (i) {
								rawVal += i + 1 == encTypeData.length ? encTypeData[i] : encTypeData[i] + '&';
							});

							// Add value to textarea
							$this.find('textarea').val(rawVal);
						} else {

							// Clear all fields
							$(this).find('ul.sortable li.fn').remove();

							// Check from witch tab is data
							if (encTypeData[0].indexOf('&') != -1) {

								// Split data to rows
								var encTypeRows = encTypeData[0].split('&');

								$.each(encTypeRows.reverse(), function (i) {

									// Split each row to name and value
									var rowValues = encTypeRows[i].split('=');

									// Add new row
									$this.find('ul.sortable').prepend('<li class="custom input fn"><input type="text" class="field-name" value="' + rowValues[0] + '"><input type="text" class="field-value" value="' + (encTypeRows[i].indexOf('=') != -1 ? rowValues[1] : '') + '"></li>');
								});

							} else {
								$.each(encTypeData.reverse(), function (i) {

									// Split each row to name and value
									var rowValues = encTypeData[i].split('=');

									// Add new row
									$this.find('ul.sortable').prepend('<li class="custom input fn"><input type="text" class="field-name" value="' + rowValues[0] + '"><input type="text" class="field-value" value="' + (encTypeData[i].indexOf('=') != -1 ? rowValues[1] : '') + '"></li>');
								});
							}
						}
					});
				});
			}

			// Load data by AJAX
			/*
				$('form#TestApiFunctionIndexForm').find('button#submit').click(function() {
					var mainForm = $('form#TestApiFunctionIndexForm');
					var headerForm = $('form#TestApiHeaderIndexForm');
					var clear = $('#Clear');
					var section = $('#Results');

					$('#Loader').show();
					section.html('');
					clear.hide();

					// Load
					$.post('/basetest/execute', 'envId' + '=' + $('form#envActions').find('ul li').first().find('a.env-edit').attr('data-id') + '&' + 'encType' + '=' + $('.nav-tabs').find('li.active a').text() + '&' + 'body' + '=' + $(this).parent().find('textarea').val().replace(/&/g, '%26') + '&' + headerForm.serialize() + '&' + mainForm.serialize(), function(response) {
						section.html(response);
						section.find('.response').jsonPainter();
						$('#Loader').hide();
						clear.show();
					});

					return false;
				});
			*/

			// AJAX function edit
			window.initializeApiListClick = function () {
				$('div.side-bar').find('ul.nav li a').each(function () {

					$(this).off('click').click(function () {

						// Function id
						var functionId = $(this).attr('data-id');

						// Get values from model
						/*
										$.ajax({
											url : "<?= '/' . $locale . '/' ?>test/get_api_function/",
						dataType : "json",
						type : "POST",
						data : {'fnId' : functionId},
						success : function(data) {

							if(data.length) {
								$.each(data, function(i) {

									// Set id of item
									$('form#TestApiFunctionIndexForm').attr('data-id', data[i].id);

									// Set value of dropdown
									setSelectValue('TestApiFunctionTestApiFunctionGroupId', data[i].group_id);

									// Set other values
									$('#TestApiFunctionName').val(data[i].name);
									$('#TestApiFunctionUrl').val(data[i].url);

									// Set selected text of Http type
									$("#TestApiFunctionHttpType option:contains(" + data[i].http_type + ")").attr('selected', 'selected');

									// Open appropriate tab and fill input fields
									$('ul.nav-tabs').find('li').each(function() {
										if($(this).text() == data[i].enc_type) {
											$(this).find('a').trigger('click')
										}
									});

									// Check where to put body text or items
									$('div#ContentTab0').find('ul.sortable li.fn').remove();
									$('#raw-text').val('');

									// Fill textarea field with data
									$('#raw-text').val(data[i].raw_body);

									// Fill each text field with data
									$.each(data[i].body, function(name, value) {
										$('div#ContentTab0 ul.sortable').prepend('<li class="custom input fn"><input type="text" class="field-name" value="' + name + '"><input type="text" class="field-value" value="' + value + '"></li>');
										$('div#ContentTab1 ul.sortable').prepend('<li class="custom input fn"><input type="text" class="field-name" value="' + name + '"><input type="text" class="field-value" value="' + value + '"></li>')
									});

								});
							}
						},
						error : function() {}
					});
	*/

						// Display edit form if it is hidden
						if (!$('form#TestApiFunctionIndexForm').is(":visible")) {
							$('.api-test-build').fadeIn();
						}
					});
				});
			};
			/*////////////////////////////////////
				function ParamsList(currentList) {
					var $this = this;

					var list = [];

					$this.put = function(param, value) {
						// redraw other tabs
						list.push({param : value};
					}

					$this.delete = function(param) {
						// redraw other tabs
						if(list[param]) {
							delete list[param];
						}
					}

					$this.getList = function() {
						return list;
					}


					if(currentList) {
						list = currentList;
						// Redraw all
					}
				}

				var paramsList = new ParamsList();

				paramsList.put('1', '2');
			//////////////////////////////////////////////*/

			$(function () {

				// Transfer data from tab to tab
				equalContent();

				// Show/hide api form
				$('.fa-plus').parent().click(function (e) {
					$('.api-test-build').fadeToggle(function () {
						$('form#TestApiFunctionIndexForm')[0].reset();
						$('form#TestApiFunctionIndexForm').attr('data-id', '');
						$('div#ContentTab0').find('ul.sortable li.fn').remove();
					});
					e.preventDefault();
				});

				// Some tabs
				$('.nav-tabs a').click(function () {
					$('.tab').hide();
					$($(this).attr('href')).show();
					$(this).closest('li').addClass('active').siblings().removeClass('active');
					$('.add-field').toggle($('#FieldTab').is(':visible'));
					return false;
				});
				$('.nav-tabs:not(.polyglot-tabs) a:first').click();

				// Sorting sidebar links
				$('.nav-sidebar, .group-header').sortable({
					axis: 'y',
					//handle: '.setter',
					placeholder: 'ui-state-highlight',
					stop: function (event, ui) {
						reorder(ui.item, ui.item.prevAll().length + 1);
					},
					start: function (event, ui) {
					}
				});

				// Sortable fields
				$('.sortable').sortable({
					axis: 'y'
				});

				// Get headers on page load
				/*
						$.ajax({
							url : "<?= '/' . $locale . '/' ?>test/get_headers/",
				dataType : "json",
				type : "POST",
				success : function(data) {
					if(data.objects.length) {
						$.each(data.objects, function(i) {
							CustomForm.addField($('#TestApiHeaderIndexForm'), data.objects[i].name, data.objects[i].value, 'headers');
						});
					}
					CustomForm.addField($('#TestApiHeaderIndexForm'), null, null, 'headers');
				},
				error : function() {}
			});
	*/

				// Get details for each api function
				initializeApiListClick();

			});

			// AJAX submit header form
			$('#TestApiHeaderIndexForm').submit(function () {
				return CustomForm.submit($(this));
			});

			// AJAX submit function form
			$('#TestApiFunctionIndexForm').submit(function () {

				var functionData = [];

				var funcId = $('form#TestApiFunctionIndexForm').attr('data-id');
				var groupId = $('#TestApiFunctionTestApiFunctionGroupId').val();
				var name = $('#TestApiFunctionName').val();
				var url = $('#TestApiFunctionUrl').val();
				var httpType = $('#TestApiFunctionHttpType option:selected').text();
				var encType = $('.nav-tabs').find('li.active a').text();

				if (name.length > 0 || url.length > 0) {
					functionData.push({'id': funcId});
					functionData.push({'groupId': groupId});
					functionData.push({'name': name});
					functionData.push({'url': url});
					functionData.push({'httpType': httpType});
					functionData.push({'encType': encType});

					var activeDiv = $('.nav-tabs').find('li.active a').attr('href');

					// Find input fields of active div
					//var encTypeData = [];
					/*if($(activeDiv).find('ul.sortable').length > 0) {
						$(activeDiv).find('ul.sortable li.custom').each(function() {
							var name = $('.field-name', $(this)).val().replace('[', '(').replace(']', ')');
							var value = $('.field-value', $(this)).val();
							if(name != '') {
								encTypeData.push(name + "=" + value);
							}
						});
					} else {
						encTypeData.push($(activeDiv).find('#raw-text').val());
					}*/

					// Add textarea content to data for sending
					// Prepare all data for sending
					functionData.push({'encTypeData': $(activeDiv).find('#raw-text').val()});

					// Send request
					$.ajax({
						url: "<?= '/' . $locale . '/' ?>test/save_api_function/",
						dataType: "json",
						type: "POST",
						data: {"fnData": functionData},
						success: function (data) {
							if (data.response) {
								alert('Function is saved!');

								if (!$('h4[data-id=' + groupId + ']').is(':visible')) {
									$('h4[data-id=' + groupId + ']').parent().append('<ul class="nav"></ul>');
									$('h4[data-id=' + groupId + ']').show();
								}
								if (data.fnId != funcId) {
									$('h4[data-id=' + groupId + ']').parent().find('ul.nav').append('<li><a href="#" data-id="' + data.fnId + '" data-target="' + url + '">' + name.toLowerCase() + '</a></li>');

									// Init click on api function
									initializeApiListClick();
								} else {
									$('h4[data-id=' + groupId + ']').parent().find('a[data-id=' + funcId + ']').attr('data-target', url).text(name.toLowerCase());
								}
							}
						},
						error: function () {
						}
					});
				} else {
					alert('Enter name and URL!');
				}

				return false;
			});


			CustomForm = {

				addField: function ($wrapper, name, value, group) {

					if (!group) group = 'base';

					if (!$wrapper.data('fieldCounter')) {
						$wrapper.data('fieldCounter', 0);
					}

					var fieldCounter = $wrapper.data('fieldCounter') + 1;

					var label = $('<input type="text" class="field-name group">')
						.attr('name', 'fields[' + group + '][' + fieldCounter + '][name]')
						.attr('data-group', group)
						.val(name);
					var input = $('<input type="text" class="field-value">')
						.attr('name', 'fields[' + group + '][' + fieldCounter + '][value]')
						.val(value);

					label.keyup(function () {

						// Add field
						if ($wrapper.find('.field-name').filter(function () {
								return $(this).val() == "";
							}).length == 0) {
							label.parent().addClass('fn');
							CustomForm.addField($wrapper, null, null, label.attr('data-group'));

							// Transfer data from tab to tab
							equalContent();

							return true;
						}

						// Remove field
						var emptyOnes = $wrapper.find('.field-name').filter(function () {
							return $(this).val() == "";
						});
						if ($(this).val() == '' && emptyOnes.length > 1) {
							$(this).parent().remove();
							$(emptyOnes[emptyOnes.length - 1]).focus();
							return true;
						}
					});

					var item = $wrapper.selector == '#group-sorted' ? $('<li class="custom input" style="display:none">').append(label) : $('<li class="custom input" style="display:none">').append(label).append(input);
					$wrapper.find('ul').append(item);
					item.fadeIn();
					$wrapper.data('fieldCounter', fieldCounter);
				},

				submit: function (form) {
					var headers = [];
					$('li.custom').each(function () {
						var name = $('.field-name', $(this)).val().replace('[', '(').replace(']', ')');
						var value = $('.field-value', $(this)).val();
						if (name != '') {
							headers.push(name + "-" + value);
						}
					});

					// Send request
					$.ajax({
						url: "<?= '/' . $locale . '/' ?>test/save_headers/",
						dataType: "json",
						type: "POST",
						data: {"headers": headers},
						success: function (response) {
							if (response) {
								alert('Headers are updated!');
							}
						},
						error: function () {
						}
					});
					return false;
				}
			};
			CustomForm.addField($('#ContentTab0'), null, null, 'enctype');
			CustomForm.addField($('#sorted'), null, null, 'form');
			CustomForm.addField($('#group-sorted'), null, null, 'group');

			///////////////	////////////////////////////////////////////////////////////////////////////////////////////////////////////////
			// Show the form
			$('.sidenav a').click(function () {
				$('form.api').hide();
				$('form.api[rel="' + $(this).data('target') + '"]').show();
				$('.sidenav li.active').removeClass('active');
				$(this).closest('li').addClass('active');
			});

			// Click on the first tab
			jQuery('.sidenav a:first').click();

			// Submit form
			$('#Submit').click(function () {
				$('form.api:visible').submit();
			});

			// Load data by AJAX
			$('form#api').submit(function () {
				var form = $(this);
				var clear = $('#Clear');
				var section = $('#Results');

				$('#Loader').css('visibility', 'auto');
				section.html('');
				clear.hide();

				// Load
				$.post('/basetest/execute', $('form#mandatory').serialize() + '&' + form.serialize(), function (response) {
					section.html(response);
					section.prepend('<h3>Results:</h3>');
					section.find('.response').jsonPainter();
					$('#Loader').css('visibility', 'hidden');
					clear.show();
				});

				return false;
			});
			// >>>>>>>>>>>>>>>>>>>>>>>>>>> EOF api test


			// >>>>>>>>>>>>>>>>>>>>>>>>>>> Search
			// Quick filter
			$("#QuickFilter").focus().select().bind('input propertychange', function () {

				// When value of the input is not blank
				if ($(this).val() != "") {
					$("div.bs-docs-sidebar ul > li").hide();
					$("div.bs-docs-sidebar ul li:contains-ci('" + $(this).val() + "')").show();

					// Handle empty results
					if (!$("div.bs-docs-sidebar ul > li:visible").size()) {
						$('#EmptyQuickFilter').show();
					} else {
						$('#EmptyQuickFilter').hide();
					}

					// When there is no input or clean again, show everything back
				} else {
					$("div.bs-docs-sidebar ul > li").show();
					$('#EmptyQuickFilter').hide();
				}
			});

			// Case insensitive contains
			$.extend($.expr[":"], {
				"contains-ci": function (elem, i, match, array) {
					return (elem.textContent || elem.innerText || $(elem).text() || "").toLowerCase().indexOf((match[3] || "").toLowerCase()) >= 0;
				}
			});
			// >>>>>>>>>>>>>>>>>>>>>>>>>>> EOF Search

			// Toggle header
			function toggleHeader() {
				$('#TestApiHeaderIndexForm').toggle('slow');
			}

		</script>
	</div>
</div>
