<?php

App::uses('SeoGeneratorFactory', 'Seo.Model/MetaGenerators');
App::uses('SeoGenerator', 'Seo.Model/MetaGenerators');
class SeoComponent extends Component {

	var $tagDescriptions = array();

# ~ Render sitemap xml - - - - - - - - - - - - - - - - - - - - - - - - - - - - #
	public function renderSitemap($map = null) {
		$sitemapGenerator = ClassRegistry::init('Seo.SitemapGenerator');
		$sitemapGenerator->echoSitemap($map);
	}


# ~ Get Meta Tags for page - - - - - - - - - - - - - - - - - - - - - - - - - - #
	public function getMetaTags($page, $request) {
		# Get models
		$this->MetaTag = ClassRegistry::init('Seo.MetaTag');
		$this->SeoConfig = ClassRegistry::init('SeoConfig');

		# Get global seo configuration
		$this->seoConfig = $this->SeoConfig->find('first');

		# Get global metatags
		$global = $this->getGlobalMainTags($this->seoConfig) + (!empty($this->seoConfig['Seo']['metatag']) ? (array)$this->seoConfig['Seo']['metatag'] : []);

		# Get generated metatags
		$generated = $this->MetaTag->extractGeneratedTags($page);

		$allTags = $generated + $global;

		# Trigger runtime validation
		$allTags = SeoGeneratorFactory::onRuntimeGeneration($page, $request, $allTags);

		$tagsById = $this->MetaTag->getAllById();

		foreach($allTags as $tagId => $tagValues) {
			if(!isset($tagsById[$tagId])) {
				continue;
			}
			$tag = $tagsById[$tagId];

			if($tagId == 1 || $tag['inherits'] == 1) {
				foreach($tagValues as $locale => $tagValue) {
					if(strlen($tagValue) < 20) {
						$allTags[$tagId][$locale] = $tagValue . ' ' . @$this->seoConfig['SeoConfig']['global_short_title_suffix__'][$locale];
					}
				}
			}
		}

		# Return joined
		return $allTags;
	}


	# ~ Get page title - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - #
	public function getPageTitle($page, $request) {
		// Get meta source
		if($page['Page']['type'] == Page::TYPE_MODULE) {
			$metaSource = $page['Data'][$page['Module']['name']];
		} else {
			$metaSource = $page['Page'];
		}

		// If custom meta title provided, use it as title
		if($metaSource['meta'] === '' && !empty($metaSource['meta_title'])) {
			return array($metaSource['meta_title']);
		}

		// Get title suffix and append it to page title
		$titleSuffix = $this->seoConfig['SeoConfig']['global_title_suffix'];
		$pageTitleArray = array(
			$page['Page']['title'],
			$titleSuffix
		);

		return array_filter($pageTitleArray);
	}


# ~ Tag descriptions setter- - - - - - - - - - - - - - - - - - - - - - - - - - #
	public function setTagDescriptions($tagDescriptions) {
		$this->tagDescriptions = $tagDescriptions;
	}


# ~ Get SEO config - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - #
	public function getConfig() {
		$seoConfig = ClassRegistry::init('SeoConfig')->find('first');
		$seoConfig = reset($seoConfig);
		return $seoConfig;
	}


# ~ Get global metatags  - - - - - - - - - - - - - - - - - - - - - - - - - - - #
	private function getGlobalMainTags($seoConfig) {
		$mainTags = array();
		foreach(array('title', 'description', 'keywords') as $mainTag) {
			if(!empty($seoConfig['SeoConfig']['global_meta_' . $mainTag])) {
				foreach($this->tagDescriptions as $tagId => $tagDescription) {
					if($tagDescription['name'] == $mainTag && $tagDescription['is_main']) {
						$mainTags[$tagId] = isset($seoConfig['SeoConfig']['global_meta_' . $mainTag . '__']) ?
							$seoConfig['SeoConfig']['global_meta_' . $mainTag . '__'] :
							$seoConfig['SeoConfig']['global_meta_' . $mainTag];
					}
				}
			}
		}

		# Get global meta image
		if(!empty($seoConfig['GlobalMetaImage']['file'])) {
			foreach($this->tagDescriptions as $tagId => $tagDescription) {
				if($tagDescription['name'] == 'image' && $tagDescription['is_main']) {
					$mainTags[$tagId] = FRONT_BASE_URL . $seoConfig['GlobalMetaImage']['file'];
				}
			}
		}

		# Generate child tags
		$mainTags += SeoGenerator::generateChildTags($mainTags, $this->tagDescriptions);
		return $mainTags;
	}


	public function alterTag($replaceTagId, $newValues, $oldValues)
	{
		$tags = $this->MetaTag->getAllById();

		foreach($oldValues as $tagId => $values) {
			if(!isset($tags[$tagId])) {
				continue;
			}
			if($tagId == $replaceTagId || $tags[$tagId]['inherits'] == $replaceTagId) {
				$newValues = array_merge($values, $newValues);
				$oldValues[$tagId] = $newValues;
			}
		}

		return $oldValues;
	}
}
