<?php
/**
 * @var int $total The total number of records.
 */

// Set the total and calculate the page count
$paging['total'] = $total;
$paging['pageCount'] = ceil($paging['total'] / $paging['count']);

$paging = !empty($paging) ? $paging : $this->request->params['paging'][$modelClass];
$base = preg_replace('~/page:\d~ i', '', $this->Html->url(array_merge($this->request->params['pass'], $this->request->params['named'], [ C => $this->request->params['controller'], A => $this->action, 'page' => '0' ]))) . '/';

# First
$first = $paging['page'] > 1 ? 1 : null;
$first = $this->Html->link(
	'<i class="fa fa-backward">&nbsp;</i>',
	$first ? "{$base}page:{$first}" : 'javascript: void(0)',
	[ 'class' => $first ? null : 'disabled' ]
);

# Prev
$prev = $paging['page'] > 1 ? $paging['page'] - 1 : null;
$prev = $this->Html->link(
	'<i class="fa fa-chevron-left">&nbsp;</i>',
	$prev ? "{$base}page:{$prev}" : 'javascript: void(0)',
	[ 'class' => $prev ? null : 'disabled' ]
);

# Next
$next = $paging['page'] < $paging['pageCount'] ? $paging['page'] + 1 : null;
$next = $this->Html->link(
	'<i class="fa fa-chevron-right">&nbsp;</i>',
	$next ? "{$base}page:{$next}" : 'javascript: void(0)',
	[ 'class' => $next ? null : 'disabled' ]
);

# Last
$last = $paging['page'] < $paging['pageCount'] ? $paging['pageCount'] : null;
$last = $this->Html->link(
	'<i class="fa fa-forward">&nbsp;</i>',
	$last ? "{$base}page:{$last}" : 'javascript: void(0)',
	[ 'class' => $last ? null : 'disabled' ]
);
?>

<div class="table-options clearfix">
	<div class="paging clearfix">
		<ul class="pagination">
			<li><?= $first ?></li>
			<li><?= $prev ?></li>

			<li>
			<span class="paging">
				<select class="paging-select" onchange="location.href = '<?= $base ?>page:' + $(this).val()">
					<?php for ($i = 1; $i <= $paging['pageCount']; $i++) {
						$active = $paging['page'] == $i ?>
						<option value="<?= $i ?>"<?= $active ? ' selected="selected"' : '' ?>>
							<?= __('Page') . ' ' . $i . ($active ? ' / ' . $paging['pageCount'] : null) ?>
						</option>
					<?php } ?>
				</select>
			</span>
			</li>

			<li><?= $next ?></li>
			<li><?= $last ?></li>
		</ul>

		<div class="paging-options">
			<span><?= __("Total records found:") . ' ' . $paging['total'] ?></span>
			<?php if (!empty($bottom)) { ?>
				<?= $this->Html->link(__('go to top'), '#top', 'btn btn-default btn-link') ?>
			<?php } ?>
		</div>
	</div>
</div>

<?php if (empty($header)) { ?>
	<div class="clear"></div>
<?php } ?>
