<?php
/**
 * @var \Newsletter\Model\CampaignModel $campaign
 * @var string                          $campaignId
 * @var string                          $controller
 * @var mixed                           $_actions
 */

// Set the send time
$campaign->data['schedule_time'] = strtotime($campaign->data['send_time'])
	? date(DATETIME, strtotime($campaign->data['send_time']))
	: '';

$this->Form->data = $campaign->data;

?>

<form method="post" target="">
	<div class="header">
		<?= $this->Format->actions($_actions) ?>
	</div>

	<div class="index">

		<div class="row">
			<div class="col-md-4">
				<div class="side-bar">
					<?= $this->ChimpForm->in('schedule_time', [ 'class' => 'date-time-picker' ]) ?>
					<div class="input clearfix text-center">
						<ul class="actions">
							<?php if ($campaign->data['status'] === 'schedule') { ?>
								<li>
									<button class="btn btn-default" formaction="<?= Router::url([ P => 'newsletter', C => 'campaigns', A => 'pause', $id ]) ?>">
										<i class="fa fa-fw fa-pause button"></i>
										<?= __('Pause Campaign') ?>
									</button>
								</li>
							<?php } else { ?>
								<li>
									<button type="submit" class="btn btn-primary">
										<i class="fa fa-fw fa-calendar button"></i>
										<?= __('Schedule Campaign') ?>
									</button>
								</li>
							<?php } ?>
						</ul>
					</div>
				</div>
			</div>
			<div class="col-md-8">
				<div class="input">
					<iframe name="CampaignPreview" width="100%" height="700" src="<?= str_replace('http://', 'https://', $campaign->data['archive_url']) ?>" style="border: 1px solid #cdcdcd; background: white;"></iframe>
				</div>
			</div>
		</div>
	</div>
</form>

<script>
	postExecute(function () {
		$('.date-time-picker').datetimepicker({
			dateFormat: 'yy-mm-dd',
			timeFormat: 'HH:mm:ss',
			stepHour: 1,
			stepMinute: 15,
			showSecond: false
		});
	});
</script>