<?php
/**
 * @var \Intellex\MailChimp\Resource\ResourceCampaign[] $campaigns
 * @var \Intellex\MailChimp\Resource\ResourceReport[]   $reports
 * @var string                                          $controller
 * @var mixed                                           $_actions
 */

// The options for the status
$statusOptions = [
	'save'     => [ 'floppy-o', '#bbaaaa' ],
	'paused'   => [ 'pause', '#bbaaaa' ],
	'schedule' => [ 'calendar', '#3fa04d' ],
	'sending'  => [ 'spinner fa-spin fa-pulse', 'red' ],
	'sent'     => [ 'envelope', '#3fa04d' ],
];
?>
<div class="main-content">
	<div class="header">
		<?= $this->Format->actions($_actions) ?>
	</div>

	<div class="index">
		<?= $this->Element('index/paginator', [ 'total' => $campaigns['total_items'] ]) ?>

		<table cellpadding="0" cellspacing="0" class="main-table-index">
			<thead>
			<tr class="">
				<th class="title"><?= __('Campaign title') ?></th>
				<th class="char"><?= __('List name') ?></th>
				<th class="char"><?= __('Subject') ?></th>
				<th class="date"><?= __('Recipient count') ?></th>
				<th class="date"><?= __('Emails sent') ?></th>
				<th class="date"><?= __('Opened') ?></th>
				<th class="date"><?= __('Clicked') ?></th>
				<th class="date"><?= __('Sent') ?></th>
				<th class="bool"><?= __('Status') ?></th>
				<th class="actions"><?= __('Actions') ?></th>
			</tr>
			</thead>

			<tbody>
			<?php foreach ($campaigns['campaigns'] as $campaign) { ?>
				<tr>
					<td class="title"><a href="<?= Router::url([ P => 'newsletter', C => 'campaigns', A => $campaign->status == 'sent' ? 'report' : 'create', $campaign->id ]) ?>"><?= $campaign->title ?></a></td>
					<td class="char"><?= $this->Html->link($campaign->listName, [ P => 'newsletter', C => 'lists', A => 'details', $campaign->listId ]) ?></td>
					<td class="char"><?= $campaign->subject ?></td>
					<td class="date"><?= $campaign->recipientCount ?></td>
					<td class="date"><?= $campaign->emailsSent ? $campaign->emailsSent : $this->Html->tag('span', '-', [ 'style' => 'color:#888' ]) ?></td>
					<td class="date right">
						<?php if (key_exists($campaign->id, $reports)) {
							echo $reports[$campaign->id]->getUniqueOpens() . ' (' . sprintf('%.2f', $reports[$campaign->id]->getOpenRate()) . '%)';
						} else echo $this->Html->tag('span', '-', [ 'style' => 'color:#888' ]) ?>
					</td>
					<td class="date right">
						<?php if (key_exists($campaign->id, $reports)) {
							echo $reports[$campaign->id]->getUniqueClicks() . ' (' . sprintf('%.2f', $reports[$campaign->id]->getClickRate()) . '%)';
						} else echo $this->Html->tag('span', '-', [ 'style' => 'color:#888' ]) ?>
					</td>
					<td class="date">
						<?php if (key_exists($campaign->id, $reports) || $campaign->status == 'schedule') {
							echo $this->Format->time($campaign->sendTime, true);
						} else echo $this->Html->tag('span', '-', [ 'style' => 'color:#888' ]) ?>
					</td>
					<td class="bool">
						<i
							class="fa fa-<?= $statusOptions[$campaign->status][0] ?>"
							style="color: <?= $statusOptions[$campaign->status][1] ?>;"
							title="<?= $campaign->status ?>">
						</i>
					</td>

					<td class="actions">
						<div class="actions">
							<ul class="actions narrow-actions">
								<li>
									<a href="<?= Router::url([ P => 'newsletter', C => 'campaigns', A => $campaign->status == 'sent' ? 'report' : 'create', $campaign->id ]) ?>" class="btn btn-default btn-sm btn-icon-only"><i class="fa fa-fw fa-<?= $campaign->status == 'sent' ? 'eye' : 'pencil' ?> button"></i></a>
								</li>
								<li>
									<a href="<?= Router::url([ P => 'newsletter', C => 'campaigns', A => 'remove', $campaign->id ]) ?>" class="btn btn-danger btn-sm btn-icon-only" onclick="if (confirm(&quot;Are you sure you want to delete:\n <?php echo $campaign->title ?> ?&quot;)) { return true; } return false;"><i class="fa fa-fw fa-trash-o button"></i></a>
								</li>
							</ul>
						</div>
						<div class="clear"></div>
					</td>
				</tr>
			<?php } ?>
			</tbody>
		</table>
	</div>

</div>