<?php
/**
 * @var \Newsletter\Model\CampaignModel             $campaign
 * @var string                                      $campaignId
 * @var \Intellex\MailChimp\Resource\ResourceList[] $lists
 * @var mixed                                       $templates
 * @var string                                      $controller
 * @var mixed                                       $_actions
 * @var string                                      $path The path to where the templates are stored.
 * @var \Newsletter\Builder\Parser                  $vars The list of variables for the template.
 */

// Set options
$options = [
	'id' => [ 'type' => 'hidden' ]
];

// Set the form
if (isset($campaign) && $campaign !== null) {
	$this->Form->data = $campaign->data;
}

// Set the iframe src
$src = Router::url([ P => 'newsletter', C => 'campaigns', A => 'preview', $id ]);

?>

<?php if (empty($templates)) { ?>
	<p class="info warn text-center" style="padding: 10px;">
		<?= __("There are no HTML templates found.%sPlease create them in %s", '<br />', '<strong>' . $path . '</strong>') ?>
	</p>
<?php } else { ?>
	<form method="post" target="">
		<div class="header">
			<?= $this->Format->actions($_actions) ?>
		</div>

		<div class="index">
			<div class="row">
				<div class="col-md-4 col-lg-3">
					<div class="side-bar">
						<?= $this->ChimpForm->in('id', [ 'type' => 'hidden' ]) ?>
						<?= $this->ChimpForm->in('title', [], []) ?>
						<?= $this->ChimpForm->in('subject', [], [ 'settings.subject_line' ]) ?>
						<?= $this->ChimpForm->in('from_name', [], [ 'settings.from_name' ]) ?>
						<?= $this->ChimpForm->in('from_email', [], [ 'settings.reply_to' ]) ?>
						<?= $this->ChimpForm->in('list_id') ?>
						<?= $this->ChimpForm->in('template') ?>
						<div class="input clearfix text-center">
							<ul class="actions">
								<li>
									<button type="submit" class="btn btn-primary">
										<i class="fa fa-fw fa-save button"></i>
										<?= __('Save Content') ?>
									</button>
								</li>
							</ul>
						</div>
					</div>
				</div>

				<div class="col-md-8 col-lg-9">
					<div class="with-sidebar">
						<?php if (empty($template)) { ?>
							<div class="form">
								<p class="well-warning well">
									<?= __('Please select template and save this campaign.') ?>
								</p>
							</div>

						<?php } else { ?>

							<div id="CampaignTemplate">
								<div class="row">
									<div class="col-md-4">
										<div class="input clearfix no-padding">
											<?php foreach ($vars as $var) { ?>
												<?= $this->element('Vars/' . $var->getType(), [ 'var' => $var ]) ?>
											<?php } ?>
										</div>
									</div>

									<div class="col-md-8">
										<div class="input">
											<iframe name="CampaignPreview" src="" width="100%" height="700" style="border: 1px solid #cdcdcd; background: white;"></iframe>
										</div>
									</div>
								</div>
							</div>
						<?php } ?>

						<?php if (isset($error)) { ?>
							<pre class="info issue"><?= $error ?></pre>
						<?php } ?>

						<?php if (isset($response)) { ?>
							<pre class="info ok"><?= $response ? str_replace([ '<', "	" ], [ '&lt;', '' ], print_r($response, true)) : ' ~ empty response ~ ' ?></pre>
						<?php } ?>
					</div>
				</div>
			</div>
		</div>

	</form>

	<script>
		window.postExecuteStack.push(function () {
			var inputs = $('#CampaignTemplate').find('input, select, textarea');
			inputs.change(function () {
				var form = $(this).closest('form')[0];
				form.target = 'CampaignPreview';
				form.action = '/newsletter/campaigns/preview/<?= $id ?>';
				form.submit();

				// Revert changes
				form.removeAttribute('target');
				form.removeAttribute('action');
			});

			// Auto preview on load
			$(inputs[0]).change();
		});

		$(document).ready(function () {
			$('iframe').css('height', $('#CampaignTemplate').outerHeight());
		})
	</script>
<?php } ?>