<?php namespace Newsletter\Model;

use Intellex\MailChimp\Resource\ResourceList;

class ListModel {

	/** @var array The data for this model. */
	public $data;

	/** @var string[] The list of errors for each field. */
	public $errors = [];

	/** @var string[] The list of all fields. */
	private $fields = [
		'id',
		'title',
	];

	/**
	 * CampaignModel constructor.
	 *
	 * @param array $data The data for the model.
	 */
	public function __construct($data = []) {

		// Set default values
		foreach ($this->fields as $field) {
			if (!key_exists($field, $data)) {
				$data[$field] = null;
			}
		}

		$this->data = $data;
		$this->validate();
	}

	/**
	 * Create the model from the resource.
	 *
	 * @param ResourceList $list The campaign to build from.
	 *
	 * @return ListModel The initialize model.
	 */
	public static function build(ResourceList $list) {
		return new ListModel([
			'id'   => $list->id,
			'name' => $list->name,
		]);
	}

	/**
	 * Validate the current state.
	 *
	 * @return bool True if there are no errors, false otherwise.
	 */
	private function validate() {
		$this->errors = [];

		return empty($this->errors);
	}

}