<?php namespace Newsletter\Builder;

abstract class TemplateHelper {

	/**
	 * Get the HTML data attribute for the selected value of a template variable.
	 *
	 * @param string $name  The name of the variable.
	 * @param mixed  $value The value of the variable.
	 * @param bool   $array True to set as array, false to set as single value.
	 *
	 * @return string Teh complete HTML attribute.
	 */
	public static function dataTemplateVar($name, $value, $array = false) {
		$data = [
			$array ? 'array' : 'single',
			urlencode($name),
			urlencode($value)
		];

		return ' data-template-var="' . implode('/', $data) . '"';
	}

}