<?php

/**
 * Class SearchController
 * Search for the module to add into the relationship.
 */
class SearchController extends AppBackendController {

	/** @inheritdoc No model. */
	public $uses = false;

	/** @inheritdoc */
	public $components = [ 'Api' ];

	/**
	 * Find the possible item for the relationship.
	 *
	 * @param string $module       The name of the module whose relationship to search.
	 * @param string $relationship The name of the relationship to search.
	 */
	public function index($module, $relationship) {

		// Get the parameters
		$conditions = key_exists('conditions', $this->request->data) ? $this->request->data['conditions'] : [];
		$page = key_exists('page', $this->request->data) ? $this->request->data['page'] : 1;

		// Return the value
		$this->Api->build(ClassRegistry::init($module)->getRelationship($relationship)->find($conditions, $page));
	}

}