<div class="view index">
	<div class="row-fluid">
		<div class="col-sm-6">
			<div class="block">
				<h2>
					<span>
						<i class="fa fa-fw fa-info" style="font-size: 20px"></i>
						<?= __('Basic Info: %s', $record[$modelClass]['name']) ?>
					</span>
				</h2>
				<div class="block-body job-info-body">
					<ul>
						<li><strong><?= __('Description') ?>:</strong> <?= $record[$modelClass]['description'] ?></li>
						<li><strong><?= __('Created') ?>:</strong> <?= $record[$modelClass]['created'] ?></li>
						<li><strong><?= __('Cron Expression') ?>:</strong> <?= $record[$modelClass]['expression'] ?></li>
						<li><strong><?= __('Active') ?>:</strong> <i class="fa fa-<?= $record[$modelClass]['is_active'] ? 'check' : 'remove' ?>"></i></li>
					</ul>
				</div>
			</div>
		</div>
		<div class="col-sm-6">
			<div class="block">
				<h2>
					<span>
						<i class="fa fa-fw fa-play" style="font-size: 20px"></i>
						<?= __('Execution info') ?>
					</span>
				</h2>
				<div class="block-body execution-info-body">
					<div class="row">
						<div class="col-sm-6">
							<h4><?= __('Last Run') ?></h4>
							<?php if(empty($lastRun)) { ?>
								<p><?= __('Never') ?></p>
							<?php } else { ?>
								<ul>
									<li class="job-status"><strong><?= __('Status') ?>:</strong> <i class="fa fa-fw green fa-<?= $lastRun['CronJobLog']['status'] ? 'check' : 'remove' ?>"></i></li>
									<li><strong><?= __('Started') ?>:</strong> <?= $lastRun['CronJobLog']['started'] ?></li>
									<li><strong><?= __('Finished') ?>:</strong> <?= $lastRun['CronJobLog']['finished'] ?></li>
								</ul>
							<?php } ?>
						</div>
						<div class="col-sm-6 current-running-holder">
							<h4><?= __('Currently running') ?></h4>
								<div class="not-running" style="display:none">
									<i class="current-running-icon fa fa-fw green fa-remove"></i>
									<div class="clear"></div>
									<a href="javascript:void(0)" class="btn-trigger-run btn btn-primary" data-job-id="<?= $record[$modelClass]['id'] ?>"><i class="fa fa-fw fa-play"></i><?= __('Run') ?></a>
								</div>
								<div class="running" style="display:none">
									<i class="current-running-icon fa fa-fw green fa-check"></i>
									<ul>
										<li><strong><?= __('Process ID') ?>:</strong> <span class="job-pid"></span></li>
										<li><strong><?= __('Started') ?>:</strong> <span class="job-started"></span></li>
										<li><strong><?= __('CPU Usage') ?>:</strong> <span class="job-cpu"></span>%</li>
										<li><strong><?= __('Memory Usage') ?>:</strong> <span class="job-memory"></span>%</li>
									</ul>
								</div>
						</div>
					</div>
					<div class="row next-run">
						<div class="next-run col-sm-12">
							<strong><?= __('Next Run') ?>:</strong> <?= $nextRun->format('Y-m-d H:i:s') ?>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

	<div class="row-fluid">
		<div class="col-sm-12">
			<div class="block">
				<h2>
					<span>
						<i class="fa fa-fw fa-list" style="font-size: 20px"></i>
						<?= __('Last runs') ?>
					</span>
				</h2>
				<div>
					<table cellpadding="0" cellspacing="0" class="main-table-index"s>
						<thead>
							<tr class="">
								<th id="th-name" class="title"><?= __('Started') ?></th>
								<th class="char">
									<?= __('Finished') ?>
								</th>
								<th class="char">
									<?= __('Status') ?>
								</th>
								<th class="char">
									<?= __('Logs') ?>
								</th>
							</tr>
						</thead>
						<tbody>

						<?php foreach($lastRuns as $lastRun) { ?>
							<tr>
								<td class="title"><?= $lastRun['CronJobLog']['started'] ?></td>
								<td class="char"><?= $lastRun['CronJobLog']['started'] ?></td>
								<td class="bool">
									<i class="fa fa-<?= $lastRun['CronJobLog']['status'] ? 'check' : 'remove' ?>"></i>
								</td>
								<td class="char"><a href="<?= $this->Html->url(array(P => 'cronner', C => 'cronJobs', A => 'downloadLog', $lastRun['CronJobLog']['id'])) ?>" target="_blank"><?= __('Download') ?></a></td>
							</tr>
						<?php } ?>
						</tbody>
					</table>
				</div>
			</div>
		</div>
	</div>
</div>


<style>
	.block .block-body {
		padding: 1%;
	}

	.execution-info-body {
		text-align: center;
	}
	.execution-info-body h4 {
		font-weight: bold;
		font-size: 2em;
	}
	.execution-info-body .fa-check {
		color: green;
	}
	.execution-info-body .fa-remove {
		color: red;
	}
	.execution-info-body li.job-status {
		font-size: 1.5em;
		margin: 10px 0;
	}

	.execution-info-body .next-run {
		margin-top: 20px;
		font-size: 1.3em;
	}
	.execution-info-body .current-running-icon {
		font-size: 2em;
	}

	.job-info-body {
		font-size: 1.2em;
	}
</style>


<script>
	var JobView = {

		options: {
			baseUrl: '/cronner/cronJobs/',
			jobId: null
		},

		jobStatus: {
			running: null
		},

		init: function(options) {
			this.options = $.extend(this.options, options);
			this.initializeListeners();
			this.initializePooling();
		},

		initializeListeners: function() {
			var self = this;
			$('.btn-trigger-run').click(function() {
				self.triggerRun($(this).data('job-id'));
			});
		},

		initializePooling: function() {
			if(this.options.jobId == null) {
				return;
			}

			this.poolStatus(this.options.jobId);
		},

		poolStatus: function(jobId) {
			var self = this;
			$.ajax({
				url : this.options.baseUrl + 'status/' + jobId,
				type : 'post',
				dataType: 'json',
				data: {
					running : self.jobStatus.running
				},
				success: function(data) {
					var oldRunning = self.jobStatus.running;
					self.jobStatus.running = data.response.running;
					self.jobStatus.data = data.response.data;

					if(oldRunning == true && self.jobStatus.running == false) {
						return window.location.reload(true);
					}

					self.renderStatus();
					self.poolStatus(jobId);


				}
			});
		},

		triggerRun : function(jobId) {
			$.ajax({
				url : this.options.baseUrl + 'trigger/' + jobId,
				type : 'get',
				dataType: 'json',
				success: function(data) {
				}
			});
		},

		renderStatus: function() {
			var $wrapper = $('.current-running-holder');
			if(this.jobStatus.running == true) {
				$wrapper.find('.running').show();
				$wrapper.find('.not-running').hide();

				$wrapper.find('.running').find('.job-pid').text(this.jobStatus.data.pid);
				$wrapper.find('.running').find('.job-started').text(this.jobStatus.data.started);
				$wrapper.find('.running').find('.job-cpu').text(this.jobStatus.data.cpu);
				$wrapper.find('.running').find('.job-memory').text(this.jobStatus.data.memory);
			} else {
				$wrapper.find('.not-running').show();
				$wrapper.find('.running').hide();
			}
		}

	};


	$(document).ready(function() {
		JobView.init({
			jobId: <?= $record[$modelClass]['id'] ?>
		});

	})
</script>