<?php

$commonOptions = $model->getCommonOptions();
$minuteOptions = $model->getMinuteOptions();
$hourOptions = $model->getHourOptions();
$dayOptions = $model->getDayOptions();
$monthOptions = $model->getMonthOptions();
$weekdayOptions = $model->getWeekdayOptions();

$cronSelectOptions = array('div' => null, 'label' => false, 'type' => 'select', 'empty' => __('-- Common Settings --'), 'class' => 'common-option');

$selects = array(
	'minute' => $this->Form->input('minute_options', array_merge($cronSelectOptions, array('options' => $minuteOptions))),
	'hour' => $this->Form->input('hour_options', array_merge($cronSelectOptions, array('options' => $hourOptions))),
	'day' => $this->Form->input('day_options', array_merge($cronSelectOptions, array('options' => $dayOptions))),
	'month' => $this->Form->input('month_options', array_merge($cronSelectOptions, array('options' => $monthOptions))),
	'weekday' => $this->Form->input('week_options', array_merge($cronSelectOptions, array('options' => $weekdayOptions))),
);

echo $this->Form->create(
	$modelClass,
	array(
		'url' => array(C => $controller, A => 'form'),
		'class' => 'tabbed',
		'onsubmit' => 'dataSubmited = true; $(".is-translated").attr("disabled", false); return true;')
);

echo $this->Form->input('id');
?>
<div class="row-fluid">

	<div class="col-sm-6 clearfix">
		<div class="well">
			<p class="h4"><?= __('Basic Info') ?></p>

			<?php
			echo $this->Form->input('name');
			echo $this->Form->input('description');
			echo $this->Form->input('handler', array('type' => 'select', 'options' => $handlers));
			echo $this->Form->input('is_active', array('type' => 'checkbox'));
			echo $this->Form->input('common_settings', array('type' => 'select', 'options' => $commonOptions, 'empty' => __('-- Common Settings --'), 'class' => 'txt-global-common-settings'));
			?>
		</div>
	</div>

	<div class="col-sm-6 clearfix custom-options-fields">
		<?php if (isset($this->validationErrors[$model->alias]['expression'])) { ?>
			<?php foreach ($this->validationErrors[$model->alias]['expression'] as $error) { ?>
				<div class="alert alert-danger">
					<?= $error ?>
				</div>
			<?php } ?>
		<?php } ?>
		<div class="well">
			<p class="h4"><?= __('Custom Timing Options') ?></p>

			<?= $this->Form->input('minute', array('between' => $selects['minute'])) ?>
			<?= $this->Form->input('hour', array('between' => $selects['hour'])) ?>
			<?= $this->Form->input('day', array('between' => $selects['day'])) ?>
			<?= $this->Form->input('month', array('between' => $selects['month'])) ?>
			<?= $this->Form->input('weekday', array('between' => $selects['weekday'])) ?>
		</div>

	</div>
</div>

<div class="clear"></div>

<?= $this->Form->close(); ?>

<script>

	var CronJobForm = {

		globalSelect: null,
		customFields: null,

		init: function () {
			this.globalSelect = $('.txt-global-common-settings');
			this.customFields = $('.custom-options-fields input');
			this.initializeListeners();
		},

		initializeListeners: function () {
			var self = this;
			$('.common-option').change(function () {
				self.handleCommonSelect($(this));
			});

			this.customFields.keyup(function () {
				self.handleCommonInput($(this));
			});

			this.globalSelect.change(function () {
				self.handleGlobalChange($(this));
			});

			this.customFields.trigger('keyup');

		},

		handleCommonSelect: function ($input) {
			$input.parent().find('input').val($input.val());
			this.matchGlobal();
		},

		handleCommonInput: function ($input) {
			var value = $input.val();

			var $select = $input.parent().find('select');

			var option = $select.find('option').filter(function () {
				return $(this).val() == value;
			});

			if (option.length > 0) {
				$select.val(value);
			} else {
				$select.val('');
			}

			this.matchGlobal();
		},

		handleGlobalChange: function ($input) {
			var self = this;
			var value = $input.val();

			if (value.trim().length == 0) {
				return;
			}

			var items = value.split(' ');

			$.each(items, function (index, value) {
				var field = self.customFields.get(index);
				$(field).val(value);
				$(field).trigger('keyup');
			})
		},

		matchGlobal: function () {
			// Build expression
			var expression = '';
			$.each(this.customFields, function (index, field) {
				expression = expression + $(field).val() + ' ';
			});

			expression = expression.trim();

			this.globalSelect.val(expression);
		}
	};

	$(document).ready(function () {
		CronJobForm.init();
	});

</script>