<?php
App::uses('CronnerAppController', 'Cronner.Controller');
App::uses('HandlerRegistry', 'Cronner.Handler');
class CronnerDashboardController extends CronnerAppController {

	/** @inheritdoc No model. */
	public $uses = false;

	/**
	 * Action: Show the dashboard.
	 */
	public function index() {
		$this->CronJob = ClassRegistry::init('Cronner.CronJob');
		$this->CronJobLog = ClassRegistry::init('Cronner.CronJobLog');

		$jobs = $this->CronJob->find('all');
		$handlers = HandlerRegistry::getAllHandlers();
		$totalRuns = $this->CronJobLog->getTotalRunCount();
		$totalFailedRuns = $this->CronJobLog->getTotalFailedRunCount();

		$lastFailedRuns = $this->CronJobLog->getLastFailed();

		$mainJob = $this->CronJob->getMainJobCommand();
		$mainJobExists = $this->CronJob->mainJobInstalled();

		$this->set(compact(
			'jobs',
			'handlers',
			'totalRuns',
			'totalFailedRuns',
			'lastFailedRuns',
			'mainJob',
			'mainJobExists'
		));
	}
}