<?php
class SeoRedirection extends AppModel {

	public $useTable = 'seo_redirections';
	public $isSingleItem = false;
	public $isModule = true;


# ~ Disable module editting- - - - - - - - - - - - - - - - - - - - - - - - - - #
	public function isModuleEditable() {
		return false;
	}


# ~ Initilize validation - - - - - - - - - - - - - - - - - - - - - - - - - - - #
	public function initValidation() {
		return array(
			'redirect_from' => array(
				'notBlank' => array(
					'rule' => array('validateRedirect'),
					'required' => true,
					'message' => __('Please provide valid redirect (starting with /).'))),
			'redirect_to' => array(
				'notBlank' => array(
					'rule' => array('validateRedirect'),
					'required' => true,
					'message' => __('Please provide valid redirect (starting with /).'))),
		);
	}


# ~ Redirection validation function- - - - - - - - - - - - - - - - - - - - - - #
	public function validateRedirect($check) {
		$check = reset($check);
		if(!preg_match('~^\/~', $check)) {
			return false;
		}
		return true;
	}
}
