<?php
class Config extends AppModel {

	var $useTable = 'config';

	var $order = array('id' => ASC);

	var $isSingleItem = true;

	var $paginate = 100;

	public function isAddable() {
		return false;
	}

	public function initValidation() {
		return array(
			'google_api_table_id' => array(
				array(
					'rule' => 'ga:\d+',
					'message' => __('Table id must bi in format "ga:xxxxx"')))
		);
	}

	/**
	 * Get the configuration for the JS.
	 *
	 * @return	JSON object containing complete configuration for required by
	 * the VectorCMS.
	 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
	public function getJSConfiguration() {

		# Get JS
		$js = $this->find('all', array(
			'conditions' => array(
				'is_js' => true)
		));

		# Pack configuration
		$json = array();
		foreach($js as $item) {
			$json[$item['Config']['group']][$item['Config']['name']] = $item['Config']['value'];
		}

		return $json;
	}

}
