<?php

/**
 * Class ThemeController
 * Handles all of the theme related features of the CMS.
 */
class ThemeController extends AppBackendController {

	/**
	 * The main form for the theme settings. Handles both the form and saving of the submitted data.
	 */
	public function index() {

		// If there is data to save
		if (!empty($this->request->data)) {

			// Success
			if ($this->setTheme($this->request->data['Theme'])) {
				$this->backtrack(__('Theme has been successfully updated'));

				// Error
			} else {
				$this->Session->setFlash(__('Theme could not have been updated'), 'danger');
			}

			// Load the current theme
		} else {
			$this->request->data = [ 'Theme' => Theme::getActive() ];
		}

		# Set the crumbs
		$this->crumbs[] = __('Edit CMS theme');
	}

	/**
	 * Set the current theme.
	 *
	 * @param mixed $theme The data to update the theme with.
	 *
	 * @return bool True on success, false otherwise.
	 */
	private function setTheme($theme) {
		return Theme::apply($theme);
	}

}