<?php

class ConfigsController extends AppBackendController {

	function index() {

		# Set the crumbs
		$this->crumbs[] = 'Software configuration';

		# Are there data to save
		if (!empty($this->request->data['Config'])) {

			# Build the save array
			$data = [];
			foreach ($this->request->data['Config'] as $id => $value) {
				$data[] = compact('id', 'value');
			}

			# Save the data
			if ($this->Config->saveAll($data)) {
				$this->Session->setFlash(__('Configuration has been updated.'));
				$this->redirect($this->here);
			} else {
				$this->Session->setFlash(__('Configuration could not have been save, please check your input.'));
			}

		} else {

			# Get all data and pack them
			$config = $this->Config->find('all');
			foreach ($config as $item) {
				$data[$item['Config']['group']][] = $item['Config'];
			}

			# Save the data for the form
			$this->data = $data;
		}
	}

}
