<?php

class CommentsController extends AppBackendController {

	var $name = 'Comments';

	public $uses = [ 'Comment' ];
	public $components = [ 'Api' ];

	var $paginate = [];

	function beforeFilter() {
		$this->Auth->allow('addComment', 'getComments');
		if (!$this->request->isAjax()) {
			# Make sure categories are not accessed directly
			if (empty($this->request->params['ctrl'])) {
				$this->backtrack(__('This location cannot be accessed directly'), 'danger');
			}
			$this->restrictions = [ 'Comment.model' => Inflector::Classify($this->request->params['ctrl']) ];

			parent::beforeFilter();

			# Append crumbs
			$this->crumbs[] = [
				__(ucfirst(str_replace('_', ' ', $this->request->params['ctrl']))),
				[
					C => $this->request->params['ctrl'],
					A => 'index' ]
			];
		} else {
			parent::beforeFilter();
		}

	}

	function beforeForm($id = null) {
		if (!empty($this->request->data[$this->modelClass])) {
			$model = Inflector::Classify($this->request->params['ctrl']);
			$this->request->data[$this->modelClass]['model'] = $model;
		}
	}

	public function addComment() {
		$this->Api->format = 'json';
		try {

			# Get validations errors.
			$this->Comment->set($this->request->data);
			$invalidFields = $this->Comment->invalidFields();
			$errors = $this->Comment->getErrors($invalidFields);

			# On validation errors
			if (!empty($errors['Comment'])) {
				if ($this->request->isAjax()) {
					$this->Api->build(null, [
						'errors'   => $this->Comment->getErrors(),
						'response' => false,
						'message'  => '',
					]);
				} else {
					$this->redirect();
				}
			}

			if (isset($this->request->data['Comment']['captcha_code'])) {
				require_once VECTORCMS_ROOT . 'webroot/plugins/securimage/securimage.php';
				$securimage = new Securimage();
				if ($securimage->check($this->request->data['Comment']['captcha_code']) == false) {
					$this->Comment->delete($saved);
					if ($this->request->isAjax()) {
						$this->Api->build(null, [
							'errors'   => [ 'Comment' => [ 'captcha_code' => __('Molimo unesite ispravan kod') ] ],
							'response' => false,
							'message'  => '',
						]);
					} else {
						$this->redirect();
					}
				}
			}

			# Save to database
			$saved = $this->Comment->save($this->request->data);

			# Send email
			//~ $sent = $this->sendEmail('Korisnik je poruku sa sajta', $this->request->data['CmsFormContact'])
			//~ ->emailFormat('text')
			//~ ->to(self::RECEPIENT)
			//~ ->addBcc('sabo@intellex.rs')
			//~ ->from('gateway@intellex.rs', 'Gastro Map website')
			//~ ->send();

			# Send response
			if ($this->request->isAjax()) {
				$this->Api->build(null, [
					'errors'   => [],
					'response' => true,
					'message'  => $this->Comment->successMessage,
				]);
			}
			$this->redirect();
		} catch (Exception $ex) {
			CakeLog::write('error', $ex->getMessage());

			if ($this->request->isAjax()) {
				$this->Api->build(null, [
					'errors'   => [ $ex->getMessage() ],
					'response' => true,
					'message'  => $this->Comment->failMessage,
				]);
			} else {
				$this->redirect();
			}
		}
	}

	public function getComments() {
	}
}

