<?php

class CategoriesController extends AppBackendController {

	var $name = 'Categories';
	var $paginate = [];

	function beforeFilter() {

		# Make sure categories are not accessed directly
		if (empty($this->request->params['ctrl'])) {
			$this->backtrack(__('This location cannot be accessed directly'), 'danger');
		}
		$this->restrictions = [ 'Category.model' => Inflector::Classify($this->request->params['ctrl']) ];

		parent::beforeFilter();

		# Append crumbs
		$this->crumbs[] = [
			__(Inflector::humanize(Inflector::tableize($this->name))),
			[
				C => $this->request->params['ctrl'],
				A => 'index' ]
		];
	}

	function beforeForm($id = null) {
		if (!empty($this->request->data[$this->modelClass])) {
			$model = Inflector::Classify($this->request->params['ctrl']);
			$this->request->data[$this->modelClass]['model'] = $model;
		}
	}
}

