<?php
if (!INSTALLED) {
	class InstallAssist {

		/** @string    The string used for unknown languages. * */
		const UNKNOWN = 'Unknown';

		/** @array The list of locales. * */
		private static $locales = [];

		/**
		 * Set the default locales.
		 *
		 * @param    array $locales The default locales to set.
		 */
		public static function setLocales($locales) {
			static::$locales = $locales;
		}

		/**
		 * Get a list of sql commands for each of supplied locales.
		 *
		 * @param    string $command The command to output. Must contain {{locale}} which will be replace by the locale.
		 * @param    string $locales The list of locales to set.
		 *                           return    array    The commands with the supplied locale.
		 */
		public static function sqlPolyglotRepeat($command, $locales = null) {

			# Get the default list
			if (empty($locales)) {
				$locales = static::$locales;
			}

			# Generate
			$result = [];
			foreach ($locales as $locale) {
				$result[] = static::sqlPolyglot($command, $locale);
			}

			echo implode($result);
		}

		/**
		 * Get a list of sql commands for each of supplied locales.
		 *
		 * @param    string $command The command to output. Must contain {{locale}} which will be replace by the locale.
		 * @param    string $locales The list of locales to set.
		 *
		 * @return    array    The commands with the supplied locale.
		 */
		public static function sqlPolyglotRepeatLines($command, $locales = null) {
			static::sqlPolyglotRepeat($command . PHP_EOL);
		}

		/**
		 * Get a SQL command for a specified locale.
		 *
		 * @param    string $command The command to output. Must contain {{locale}} which will be replace by the locale.
		 * @param    string $locale  The locale to set.
		 *
		 * @return    string    The command with the supplied locale.
		 */
		private static function sqlPolyglot($command, $locale) {
			return str_replace('{{locale}}', $locale, $command);
		}

		/**
		 * Get the language name from the supplied locale.
		 *
		 * @param    string $locale The locale to get the language from.
		 *
		 * @return    string    The name of the language, or 'Unknown' if not found.
		 */
		public static function getLanguageName($locale) {
			return key_exists($locale, static::$available)
				? static::$available[$locale]
				: static::UNKNOWN;
		}

		/** @array The list of all known locales and their language name. * */
		public static $available = [
			'af'  => 'Afrikaans',
			'ak'  => 'Akan',
			'sq'  => 'Albanian',
			'am'  => 'Amharic',
			'ar'  => 'Arabic',
			'hy'  => 'Armenian',
			'as'  => 'Assamese',
			'asa' => 'Asu',
			'az'  => 'Azerbaijani',
			'bm'  => 'Bambara',
			'eu'  => 'Basque',
			'be'  => 'Belarusian',
			'bem' => 'Bemba',
			'bez' => 'Bena',
			'bn'  => 'Bengali',
			'bs'  => 'Bosnian',
			'bg'  => 'Bulgarian',
			'my'  => 'Burmese',
			'ca'  => 'Catalan',
			'tzm' => 'Central Morocco Tamazight',
			'chr' => 'Cherokee',
			'cgg' => 'Chiga',
			'zh'  => 'Chinese',
			'kw'  => 'Cornish',
			'hr'  => 'Croatian',
			'cs'  => 'Czech',
			'da'  => 'Danish',
			'nl'  => 'Dutch',
			'ebu' => 'Embu',
			'en'  => 'English',
			'eo'  => 'Esperanto',
			'et'  => 'Estonian',
			'ee'  => 'Ewe',
			'fo'  => 'Faroese',
			'fil' => 'Filipino',
			'fi'  => 'Finnish',
			'fr'  => 'French',
			'ff'  => 'Fulah',
			'gl'  => 'Galician',
			'lg'  => 'Ganda',
			'ka'  => 'Georgian',
			'de'  => 'German',
			'el'  => 'Greek',
			'gu'  => 'Gujarati',
			'guz' => 'Gusii',
			'ha'  => 'Hausa',
			'haw' => 'Hawaiian',
			'he'  => 'Hebrew',
			'hi'  => 'Hindi',
			'hu'  => 'Hungarian',
			'is'  => 'Icelandic',
			'ig'  => 'Igbo',
			'id'  => 'Indonesian',
			'ga'  => 'Irish',
			'it'  => 'Italian',
			'ja'  => 'Japanese',
			'kea' => 'Kabuverdianu',
			'kab' => 'Kabyle',
			'kl'  => 'Kalaallisut',
			'kln' => 'Kalenjin',
			'kam' => 'Kamba',
			'kn'  => 'Kannada',
			'kk'  => 'Kazakh',
			'km'  => 'Khmer',
			'ki'  => 'Kikuyu',
			'rw'  => 'Kinyarwanda',
			'kok' => 'Konkani',
			'ko'  => 'Korean',
			'khq' => 'Koyra Chiini',
			'ses' => 'Koyraboro Senni',
			'lag' => 'Langi',
			'lv'  => 'Latvian',
			'lt'  => 'Lithuanian',
			'luo' => 'Luo',
			'luy' => 'Luyia',
			'mk'  => 'Macedonian',
			'jmc' => 'Machame',
			'kde' => 'Makonde',
			'mg'  => 'Malagasy',
			'ms'  => 'Malay',
			'ml'  => 'Malayalam',
			'mt'  => 'Maltese',
			'gv'  => 'Manx',
			'mr'  => 'Marathi',
			'mas' => 'Masai',
			'mer' => 'Meru',
			'mfe' => 'Morisyen',
			'naq' => 'Nama',
			'ne'  => 'Nepali',
			'nd'  => 'North Ndebele',
			'nb'  => 'Norwegian Bokmål',
			'nn'  => 'Norwegian Nynorsk',
			'nyn' => 'Nyankole',
			'or'  => 'Oriya',
			'om'  => 'Oromo',
			'ps'  => 'Pashto',
			'fa'  => 'Persian',
			'pl'  => 'Polish',
			'pt'  => 'Portuguese',
			'pa'  => 'Punjabi',
			'ro'  => 'Romanian',
			'rm'  => 'Romansh',
			'rof' => 'Rombo',
			'ru'  => 'Russian',
			'rwk' => 'Rwa',
			'saq' => 'Samburu',
			'sg'  => 'Sango',
			'seh' => 'Sena',
			'sr'  => 'Serbian',
			'sn'  => 'Shona',
			'ii'  => 'Sichuan Yi',
			'si'  => 'Sinhala',
			'sk'  => 'Slovak',
			'sl'  => 'Slovenian',
			'xog' => 'Soga',
			'so'  => 'Somali',
			'es'  => 'Spanish',
			'sw'  => 'Swahili',
			'sv'  => 'Swedish',
			'gsw' => 'Swiss German',
			'shi' => 'Tachelhit',
			'dav' => 'Taita',
			'ta'  => 'Tamil',
			'te'  => 'Telugu',
			'teo' => 'Teso',
			'th'  => 'Thai',
			'bo'  => 'Tibetan',
			'ti'  => 'Tigrinya',
			'to'  => 'Tonga',
			'tr'  => 'Turkish',
			'uk'  => 'Ukrainian',
			'ur'  => 'Urdu',
			'uz'  => 'Uzbek',
			'vi'  => 'Vietnamese',
			'vun' => 'Vunjo',
			'cy'  => 'Welsh',
			'yo'  => 'Yoruba',
			'zu'  => 'Zulu' ];

	}

	function sr($command, $locales = null) {
		InstallAssist::sqlPolyglotRepeat($command, $locales);
	}

	function srl($command, $locales = null) {
		InstallAssist::sqlPolyglotRepeatLines($command, $locales);
	}

}
