<?php

# Default start time
defined('START_TIME') or define('START_TIME', microtime(true));

# Additional definitions
$server = !empty($_SERVER['HTTP_HOST']) ? 'http://' . $_SERVER['HTTP_HOST'] : '';
define('FRONT_BASE_URL', preg_replace('~://admin(\.?+)~', '://', $server));
define('BACK_BASE_URL', str_replace('://.', '://', preg_replace('~://(www|admin)?\.~', '://admin.', $server)));
define('CMS', isCLI() || FRONT_BASE_URL != $server);

# Define CMS location
define('VECTORCMS_DIR', 'VectorCMS');
define('VECTORCMS_ROOT', ROOT . DS . VECTORCMS_DIR . DS);

# Local or remote host
define('LOCALHOST', !empty($_SERVER['REMOTE_ADDR']) && $_SERVER['REMOTE_ADDR'] === '127.0.0.1');

# Check for installed CMS
define('INSTALLED', file_exists(ROOT . '/app/Config/config.php'));
if (!INSTALLED && CMS && !preg_match('~^/install(/|$)~', $_SERVER['REQUEST_URI'])) {
	header('Location: ' . BACK_BASE_URL . '/install');
	exit(0);
}
