<?php

/**
 * Associate a namespace to a directory.
 *
 * @param string $namespace The namespace to associate to directory.
 * @param string $directory The base directory, relative to app directory.
 */
function registerAutoloadPrefix($namespace, $directory) {

	spl_autoload_register(function ($class) use ($namespace, $directory) {
		$namespace .= '\\';

		if (strpos($class, $namespace) === 0) {
			$path = APP . $directory . DS . str_replace('\\', DS, substr($class, strlen($namespace))) . '.php';
			if (file_exists($path)) {
				include $path;
				return;
			}
		}
	});
}

// Autoload from composer
$composerAutoloaderPath = ROOT . DS . 'vendor' . DS . 'autoload.php';
if (!is_readable($composerAutoloaderPath)) {
	throw new Exception("Cannot load composer autoload file from {$composerAutoloaderPath}, make sure you have properly initialized the composer.");
}
require $composerAutoloaderPath;
